package zio.aws.resourceexplorer2
import zio.aws.resourceexplorer2.model.UpdateViewResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.resourceexplorer2.{
  ResourceExplorer2AsyncClientBuilder,
  ResourceExplorer2AsyncClient
}
import zio.aws.resourceexplorer2.model.{
  UpdateViewRequest,
  DeleteViewRequest,
  CreateIndexRequest,
  GetViewRequest,
  ListTagsForResourceRequest,
  BatchGetViewRequest,
  SearchRequest,
  CreateViewRequest,
  AssociateDefaultViewRequest,
  UpdateIndexTypeRequest,
  UntagResourceRequest,
  ListSupportedResourceTypesRequest,
  ListIndexesRequest,
  DeleteIndexRequest,
  TagResourceRequest,
  ListViewsRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.resourceexplorer2.model.{
  Index,
  DisassociateDefaultViewResponse,
  DeleteViewResponse,
  GetViewResponse,
  BatchGetViewResponse,
  ListViewsResponse,
  DisassociateDefaultViewRequest,
  GetDefaultViewResponse,
  CreateIndexResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetDefaultViewRequest,
  Resource,
  ListSupportedResourceTypesResponse,
  GetIndexRequest,
  SearchResponse,
  AssociateDefaultViewResponse,
  DeleteIndexResponse,
  SupportedResourceType,
  ListIndexesResponse,
  TagResourceResponse,
  UpdateViewResponse,
  CreateViewResponse,
  UpdateIndexTypeResponse,
  GetIndexResponse
}
import scala.jdk.CollectionConverters.*
trait ResourceExplorer2 extends AspectSupport[ResourceExplorer2] {
  val api: ResourceExplorer2AsyncClient
  def deleteView(
      request: DeleteViewRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.DeleteViewResponse.ReadOnly]
  def disassociateDefaultView(): IO[AwsError, Unit]
  def getView(
      request: GetViewRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.GetViewResponse.ReadOnly]
  def listIndexes(
      request: ListIndexesRequest
  ): ZStream[Any, AwsError, zio.aws.resourceexplorer2.model.Index.ReadOnly]
  def listIndexesPaginated(
      request: ListIndexesRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.ListIndexesResponse.ReadOnly]
  def getIndex()
      : IO[AwsError, zio.aws.resourceexplorer2.model.GetIndexResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.resourceexplorer2.model.UntagResourceResponse.ReadOnly
  ]
  def createView(
      request: CreateViewRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.CreateViewResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.ReadOnly
  ]
  def getDefaultView(): IO[
    AwsError,
    zio.aws.resourceexplorer2.model.GetDefaultViewResponse.ReadOnly
  ]
  def batchGetView(
      request: BatchGetViewRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.BatchGetViewResponse.ReadOnly]
  def listSupportedResourceTypes(
      request: ListSupportedResourceTypesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly
  ]
  def listSupportedResourceTypesPaginated(
      request: ListSupportedResourceTypesRequest
  ): IO[
    AwsError,
    zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.ReadOnly
  ]
  def associateDefaultView(request: AssociateDefaultViewRequest): IO[
    AwsError,
    zio.aws.resourceexplorer2.model.AssociateDefaultViewResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.TagResourceResponse.ReadOnly]
  def deleteIndex(
      request: DeleteIndexRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.DeleteIndexResponse.ReadOnly]
  def search(request: SearchRequest): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly,
    zio.aws.resourceexplorer2.model.Resource.ReadOnly
  ]]
  def searchPaginated(
      request: SearchRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly]
  def listViews(request: ListViewsRequest): ZStream[Any, AwsError, String]
  def listViewsPaginated(
      request: ListViewsRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.ListViewsResponse.ReadOnly]
  def updateIndexType(request: UpdateIndexTypeRequest): IO[
    AwsError,
    zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.ReadOnly
  ]
  def updateView(request: UpdateViewRequest): IO[AwsError, ReadOnly]
  def createIndex(
      request: CreateIndexRequest
  ): IO[AwsError, zio.aws.resourceexplorer2.model.CreateIndexResponse.ReadOnly]
}
object ResourceExplorer2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ResourceExplorer2] =
    customized(identity)
  def customized(
      customization: ResourceExplorer2AsyncClientBuilder => ResourceExplorer2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ResourceExplorer2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ResourceExplorer2AsyncClientBuilder => ResourceExplorer2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ResourceExplorer2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ResourceExplorer2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      ResourceExplorer2AsyncClient,
      ResourceExplorer2AsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      ResourceExplorer2AsyncClient,
      ResourceExplorer2AsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ResourceExplorer2Impl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ResourceExplorer2Impl[R](
      override val api: ResourceExplorer2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ResourceExplorer2
      with AwsServiceBase[R] {
    override val serviceName: String = "ResourceExplorer2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ResourceExplorer2Impl[R1] = new ResourceExplorer2Impl(api, newAspect, r)
    def deleteView(request: DeleteViewRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.DeleteViewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest,
      DeleteViewResponse
    ]("deleteView", api.deleteView)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.DeleteViewResponse.wrap)
      .provideEnvironment(r)
    def disassociateDefaultView(): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateDefaultViewRequest,
      DisassociateDefaultViewResponse
    ]("disassociateDefaultView", api.disassociateDefaultView)(
      DisassociateDefaultViewRequest.builder().build()
    ).unit.provideEnvironment(r)
    def getView(
        request: GetViewRequest
    ): IO[AwsError, zio.aws.resourceexplorer2.model.GetViewResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest,
        GetViewResponse
      ]("getView", api.getView)(request.buildAwsValue())
        .map(zio.aws.resourceexplorer2.model.GetViewResponse.wrap)
        .provideEnvironment(r)
    def listIndexes(request: ListIndexesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.resourceexplorer2.model.Index.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest,
      ListIndexesResponse,
      Index
    ](
      "listIndexes",
      api.listIndexes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.indexes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.resourceexplorer2.model.Index.wrap(item))
      .provideEnvironment(r)
    def listIndexesPaginated(request: ListIndexesRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.ListIndexesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest,
      ListIndexesResponse
    ]("listIndexes", api.listIndexes)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.ListIndexesResponse.wrap)
      .provideEnvironment(r)
    def getIndex(): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.GetIndexResponse.ReadOnly
    ] = asyncRequestResponse[GetIndexRequest, GetIndexResponse](
      "getIndex",
      api.getIndex
    )(GetIndexRequest.builder().build())
      .map(zio.aws.resourceexplorer2.model.GetIndexResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def createView(request: CreateViewRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.CreateViewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest,
      CreateViewResponse
    ]("createView", api.createView)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.CreateViewResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def getDefaultView(): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.GetDefaultViewResponse.ReadOnly
    ] = asyncRequestResponse[GetDefaultViewRequest, GetDefaultViewResponse](
      "getDefaultView",
      api.getDefaultView
    )(GetDefaultViewRequest.builder().build())
      .map(zio.aws.resourceexplorer2.model.GetDefaultViewResponse.wrap)
      .provideEnvironment(r)
    def batchGetView(request: BatchGetViewRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.BatchGetViewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest,
      BatchGetViewResponse
    ]("batchGetView", api.batchGetView)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.BatchGetViewResponse.wrap)
      .provideEnvironment(r)
    def listSupportedResourceTypes(
        request: ListSupportedResourceTypesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest,
      ListSupportedResourceTypesResponse,
      SupportedResourceType
    ](
      "listSupportedResourceTypes",
      api.listSupportedResourceTypes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceTypes().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.resourceexplorer2.model.SupportedResourceType.wrap(item)
      )
      .provideEnvironment(r)
    def listSupportedResourceTypesPaginated(
        request: ListSupportedResourceTypesRequest
    ): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest,
      ListSupportedResourceTypesResponse
    ]("listSupportedResourceTypes", api.listSupportedResourceTypes)(
      request.buildAwsValue()
    ).map(
      zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.wrap
    ).provideEnvironment(r)
    def associateDefaultView(request: AssociateDefaultViewRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.AssociateDefaultViewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest,
      AssociateDefaultViewResponse
    ]("associateDefaultView", api.associateDefaultView)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.AssociateDefaultViewResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteIndex(request: DeleteIndexRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.DeleteIndexResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexRequest,
      DeleteIndexResponse
    ]("deleteIndex", api.deleteIndex)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.DeleteIndexResponse.wrap)
      .provideEnvironment(r)
    def search(
        request: SearchRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly,
      zio.aws.resourceexplorer2.model.Resource.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest,
      SearchResponse,
      Resource
    ](
      "search",
      api.search,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resources().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.resourceexplorer2.model.SearchResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.resourceexplorer2.model.Resource.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchPaginated(
        request: SearchRequest
    ): IO[AwsError, zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest,
        SearchResponse
      ]("search", api.search)(request.buildAwsValue())
        .map(zio.aws.resourceexplorer2.model.SearchResponse.wrap)
        .provideEnvironment(r)
    def listViews(request: ListViewsRequest): ZStream[Any, AwsError, String] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest,
        ListViewsResponse,
        java.lang.String
      ](
        "listViews",
        api.listViews,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.views().asScala)
      )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listViewsPaginated(request: ListViewsRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.ListViewsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest,
      ListViewsResponse
    ]("listViews", api.listViews)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.ListViewsResponse.wrap)
      .provideEnvironment(r)
    def updateIndexType(request: UpdateIndexTypeRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeRequest,
      UpdateIndexTypeResponse
    ]("updateIndexType", api.updateIndexType)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.wrap)
      .provideEnvironment(r)
    def updateView(request: UpdateViewRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest,
        UpdateViewResponse
      ]("updateView", api.updateView)(request.buildAwsValue())
        .map(zio.aws.resourceexplorer2.model.UpdateViewResponse.wrap)
        .provideEnvironment(r)
    def createIndex(request: CreateIndexRequest): IO[
      AwsError,
      zio.aws.resourceexplorer2.model.CreateIndexResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexRequest,
      CreateIndexResponse
    ]("createIndex", api.createIndex)(request.buildAwsValue())
      .map(zio.aws.resourceexplorer2.model.CreateIndexResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteView(request: DeleteViewRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.DeleteViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteView(request))
  def disassociateDefaultView()
      : ZIO[zio.aws.resourceexplorer2.ResourceExplorer2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateDefaultView())
  def getView(request: GetViewRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.GetViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getView(request))
  def listIndexes(request: ListIndexesRequest): ZStream[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.Index.ReadOnly
  ] = ZStream.serviceWithStream(_.listIndexes(request))
  def listIndexesPaginated(request: ListIndexesRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.ListIndexesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIndexesPaginated(request))
  def getIndex(): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.GetIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIndex())
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createView(request: CreateViewRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.CreateViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createView(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getDefaultView(): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.GetDefaultViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDefaultView())
  def batchGetView(request: BatchGetViewRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.BatchGetViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetView(request))
  def listSupportedResourceTypes(
      request: ListSupportedResourceTypesRequest
  ): ZStream[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly
  ] = ZStream.serviceWithStream(_.listSupportedResourceTypes(request))
  def listSupportedResourceTypesPaginated(
      request: ListSupportedResourceTypesRequest
  ): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSupportedResourceTypesPaginated(request))
  def associateDefaultView(request: AssociateDefaultViewRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.AssociateDefaultViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateDefaultView(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteIndex(request: DeleteIndexRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.DeleteIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIndex(request))
  def search(request: SearchRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly,
      zio.aws.resourceexplorer2.model.Resource.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.search(request))
  def searchPaginated(request: SearchRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchPaginated(request))
  def listViews(
      request: ListViewsRequest
  ): ZStream[zio.aws.resourceexplorer2.ResourceExplorer2, AwsError, String] =
    ZStream.serviceWithStream(_.listViews(request))
  def listViewsPaginated(request: ListViewsRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.ListViewsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listViewsPaginated(request))
  def updateIndexType(request: UpdateIndexTypeRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIndexType(request))
  def updateView(
      request: UpdateViewRequest
  ): ZIO[zio.aws.resourceexplorer2.ResourceExplorer2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateView(request))
  def createIndex(request: CreateIndexRequest): ZIO[
    zio.aws.resourceexplorer2.ResourceExplorer2,
    AwsError,
    zio.aws.resourceexplorer2.model.CreateIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIndex(request))
}
