package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ULong
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VideoMetadata(
    codec: Optional[String] = Optional.Absent,
    durationMillis: Optional[ULong] = Optional.Absent,
    format: Optional[String] = Optional.Absent,
    frameRate: Optional[Float] = Optional.Absent,
    frameHeight: Optional[ULong] = Optional.Absent,
    frameWidth: Optional[ULong] = Optional.Absent,
    colorRange: Optional[zio.aws.rekognition.model.VideoColorRange] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.VideoMetadata = {
    import VideoMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.VideoMetadata
      .builder()
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(
        durationMillis.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.durationMillis)
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(frameRate.map(value => value: java.lang.Float))(
        _.frameRate
      )
      .optionallyWith(
        frameHeight.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.frameHeight)
      .optionallyWith(
        frameWidth.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.frameWidth)
      .optionallyWith(colorRange.map(value => value.unwrap))(_.colorRange)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.VideoMetadata.ReadOnly =
    zio.aws.rekognition.model.VideoMetadata.wrap(buildAwsValue())
}
object VideoMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.VideoMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.VideoMetadata =
      zio.aws.rekognition.model.VideoMetadata(
        codec.map(value => value),
        durationMillis.map(value => value),
        format.map(value => value),
        frameRate.map(value => value),
        frameHeight.map(value => value),
        frameWidth.map(value => value),
        colorRange.map(value => value)
      )
    def codec: Optional[String]
    def durationMillis: Optional[ULong]
    def format: Optional[String]
    def frameRate: Optional[Float]
    def frameHeight: Optional[ULong]
    def frameWidth: Optional[ULong]
    def colorRange: Optional[zio.aws.rekognition.model.VideoColorRange]
    def getCodec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codec", codec)
    def getDurationMillis: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getFrameRate: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getFrameHeight: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("frameHeight", frameHeight)
    def getFrameWidth: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("frameWidth", frameWidth)
    def getColorRange
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoColorRange] =
      AwsError.unwrapOptionField("colorRange", colorRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.VideoMetadata
  ) extends zio.aws.rekognition.model.VideoMetadata.ReadOnly {
    override val codec: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.codec())
      .map(value => value: String)
    override val durationMillis: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.durationMillis())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val format: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => value: String)
    override val frameRate: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.frameRate())
      .map(value => value: Float)
    override val frameHeight: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.frameHeight())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val frameWidth: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.frameWidth())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val colorRange
        : Optional[zio.aws.rekognition.model.VideoColorRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.colorRange())
        .map(value => zio.aws.rekognition.model.VideoColorRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.VideoMetadata
  ): zio.aws.rekognition.model.VideoMetadata.ReadOnly = new Wrapper(impl)
}
