package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestingDataResult(
    input: Optional[zio.aws.rekognition.model.TestingData] = Optional.Absent,
    output: Optional[zio.aws.rekognition.model.TestingData] = Optional.Absent,
    validation: Optional[zio.aws.rekognition.model.ValidationData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.TestingDataResult = {
    import TestingDataResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.TestingDataResult
      .builder()
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .optionallyWith(output.map(value => value.buildAwsValue()))(_.output)
      .optionallyWith(validation.map(value => value.buildAwsValue()))(
        _.validation
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.TestingDataResult.ReadOnly =
    zio.aws.rekognition.model.TestingDataResult.wrap(buildAwsValue())
}
object TestingDataResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.TestingDataResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.TestingDataResult =
      zio.aws.rekognition.model.TestingDataResult(
        input.map(value => value.asEditable),
        output.map(value => value.asEditable),
        validation.map(value => value.asEditable)
      )
    def input: Optional[zio.aws.rekognition.model.TestingData.ReadOnly]
    def output: Optional[zio.aws.rekognition.model.TestingData.ReadOnly]
    def validation: Optional[zio.aws.rekognition.model.ValidationData.ReadOnly]
    def getInput
        : ZIO[Any, AwsError, zio.aws.rekognition.model.TestingData.ReadOnly] =
      AwsError.unwrapOptionField("input", input)
    def getOutput
        : ZIO[Any, AwsError, zio.aws.rekognition.model.TestingData.ReadOnly] =
      AwsError.unwrapOptionField("output", output)
    def getValidation: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ValidationData.ReadOnly
    ] = AwsError.unwrapOptionField("validation", validation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.TestingDataResult
  ) extends zio.aws.rekognition.model.TestingDataResult.ReadOnly {
    override val input
        : Optional[zio.aws.rekognition.model.TestingData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.input())
        .map(value => zio.aws.rekognition.model.TestingData.wrap(value))
    override val output
        : Optional[zio.aws.rekognition.model.TestingData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.output())
        .map(value => zio.aws.rekognition.model.TestingData.wrap(value))
    override val validation
        : Optional[zio.aws.rekognition.model.ValidationData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validation())
        .map(value => zio.aws.rekognition.model.ValidationData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.TestingDataResult
  ): zio.aws.rekognition.model.TestingDataResult.ReadOnly = new Wrapper(impl)
}
