package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestingData(
    assets: Optional[Iterable[zio.aws.rekognition.model.Asset]] =
      Optional.Absent,
    autoCreate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.TestingData = {
    import TestingData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.TestingData
      .builder()
      .optionallyWith(
        assets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assets)
      .optionallyWith(autoCreate.map(value => value: java.lang.Boolean))(
        _.autoCreate
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.TestingData.ReadOnly =
    zio.aws.rekognition.model.TestingData.wrap(buildAwsValue())
}
object TestingData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.TestingData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.TestingData =
      zio.aws.rekognition.model.TestingData(
        assets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoCreate.map(value => value)
      )
    def assets: Optional[List[zio.aws.rekognition.model.Asset.ReadOnly]]
    def autoCreate: Optional[Boolean]
    def getAssets
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Asset.ReadOnly]] =
      AwsError.unwrapOptionField("assets", assets)
    def getAutoCreate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoCreate", autoCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.TestingData
  ) extends zio.aws.rekognition.model.TestingData.ReadOnly {
    override val assets
        : Optional[List[zio.aws.rekognition.model.Asset.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Asset.wrap(item)
          }.toList
        )
    override val autoCreate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoCreate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.TestingData
  ): zio.aws.rekognition.model.TestingData.ReadOnly = new Wrapper(impl)
}
