package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.SNSTopicArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StreamProcessorNotificationChannel(snsTopicArn: SNSTopicArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessorNotificationChannel = {
    import StreamProcessorNotificationChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessorNotificationChannel
      .builder()
      .snsTopicArn(SNSTopicArn.unwrap(snsTopicArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StreamProcessorNotificationChannel.ReadOnly =
    zio.aws.rekognition.model.StreamProcessorNotificationChannel
      .wrap(buildAwsValue())
}
object StreamProcessorNotificationChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessorNotificationChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.StreamProcessorNotificationChannel =
      zio.aws.rekognition.model.StreamProcessorNotificationChannel(snsTopicArn)
    def snsTopicArn: SNSTopicArn
    def getSnsTopicArn: ZIO[Any, Nothing, SNSTopicArn] =
      ZIO.succeed(snsTopicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorNotificationChannel
  ) extends zio.aws.rekognition.model.StreamProcessorNotificationChannel.ReadOnly {
    override val snsTopicArn: SNSTopicArn =
      zio.aws.rekognition.model.primitives.SNSTopicArn(impl.snsTopicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorNotificationChannel
  ): zio.aws.rekognition.model.StreamProcessorNotificationChannel.ReadOnly =
    new Wrapper(impl)
}
