package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.SegmentConfidence
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartShotDetectionFilter(
    minSegmentConfidence: Optional[SegmentConfidence] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartShotDetectionFilter = {
    import StartShotDetectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartShotDetectionFilter
      .builder()
      .optionallyWith(
        minSegmentConfidence.map(value =>
          SegmentConfidence.unwrap(value): java.lang.Float
        )
      )(_.minSegmentConfidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StartShotDetectionFilter.ReadOnly =
    zio.aws.rekognition.model.StartShotDetectionFilter.wrap(buildAwsValue())
}
object StartShotDetectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartShotDetectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartShotDetectionFilter =
      zio.aws.rekognition.model
        .StartShotDetectionFilter(minSegmentConfidence.map(value => value))
    def minSegmentConfidence: Optional[SegmentConfidence]
    def getMinSegmentConfidence: ZIO[Any, AwsError, SegmentConfidence] =
      AwsError.unwrapOptionField("minSegmentConfidence", minSegmentConfidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartShotDetectionFilter
  ) extends zio.aws.rekognition.model.StartShotDetectionFilter.ReadOnly {
    override val minSegmentConfidence: Optional[SegmentConfidence] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minSegmentConfidence())
        .map(value =>
          zio.aws.rekognition.model.primitives.SegmentConfidence(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartShotDetectionFilter
  ): zio.aws.rekognition.model.StartShotDetectionFilter.ReadOnly = new Wrapper(
    impl
  )
}
