package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.UInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProtectiveEquipmentSummary(
    personsWithRequiredEquipment: Optional[Iterable[UInteger]] =
      Optional.Absent,
    personsWithoutRequiredEquipment: Optional[Iterable[UInteger]] =
      Optional.Absent,
    personsIndeterminate: Optional[Iterable[UInteger]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary = {
    import ProtectiveEquipmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary
      .builder()
      .optionallyWith(
        personsWithRequiredEquipment.map(value =>
          value.map { item =>
            UInteger.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.personsWithRequiredEquipment)
      .optionallyWith(
        personsWithoutRequiredEquipment.map(value =>
          value.map { item =>
            UInteger.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.personsWithoutRequiredEquipment)
      .optionallyWith(
        personsIndeterminate.map(value =>
          value.map { item =>
            UInteger.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.personsIndeterminate)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly =
    zio.aws.rekognition.model.ProtectiveEquipmentSummary.wrap(buildAwsValue())
}
object ProtectiveEquipmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProtectiveEquipmentSummary =
      zio.aws.rekognition.model.ProtectiveEquipmentSummary(
        personsWithRequiredEquipment.map(value => value),
        personsWithoutRequiredEquipment.map(value => value),
        personsIndeterminate.map(value => value)
      )
    def personsWithRequiredEquipment: Optional[List[UInteger]]
    def personsWithoutRequiredEquipment: Optional[List[UInteger]]
    def personsIndeterminate: Optional[List[UInteger]]
    def getPersonsWithRequiredEquipment: ZIO[Any, AwsError, List[UInteger]] =
      AwsError.unwrapOptionField(
        "personsWithRequiredEquipment",
        personsWithRequiredEquipment
      )
    def getPersonsWithoutRequiredEquipment: ZIO[Any, AwsError, List[UInteger]] =
      AwsError.unwrapOptionField(
        "personsWithoutRequiredEquipment",
        personsWithoutRequiredEquipment
      )
    def getPersonsIndeterminate: ZIO[Any, AwsError, List[UInteger]] =
      AwsError.unwrapOptionField("personsIndeterminate", personsIndeterminate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary
  ) extends zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly {
    override val personsWithRequiredEquipment: Optional[List[UInteger]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.personsWithRequiredEquipment())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.primitives.UInteger(item)
          }.toList
        )
    override val personsWithoutRequiredEquipment: Optional[List[UInteger]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.personsWithoutRequiredEquipment())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.primitives.UInteger(item)
          }.toList
        )
    override val personsIndeterminate: Optional[List[UInteger]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.personsIndeterminate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.primitives.UInteger(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentSummary
  ): zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly =
    new Wrapper(impl)
}
