package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{UInteger, Percent}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProtectiveEquipmentPerson(
    bodyParts: Optional[
      Iterable[zio.aws.rekognition.model.ProtectiveEquipmentBodyPart]
    ] = Optional.Absent,
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    id: Optional[UInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson = {
    import ProtectiveEquipmentPerson.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson
      .builder()
      .optionallyWith(
        bodyParts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bodyParts)
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(id.map(value => UInteger.unwrap(value): Integer))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly =
    zio.aws.rekognition.model.ProtectiveEquipmentPerson.wrap(buildAwsValue())
}
object ProtectiveEquipmentPerson {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProtectiveEquipmentPerson =
      zio.aws.rekognition.model.ProtectiveEquipmentPerson(
        bodyParts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        boundingBox.map(value => value.asEditable),
        confidence.map(value => value),
        id.map(value => value)
      )
    def bodyParts: Optional[
      List[zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly]
    ]
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def confidence: Optional[Percent]
    def id: Optional[UInteger]
    def getBodyParts: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly
    ]] = AwsError.unwrapOptionField("bodyParts", bodyParts)
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getId: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson
  ) extends zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly {
    override val bodyParts: Optional[
      List[zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bodyParts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.wrap(item)
        }.toList
      )
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val id: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPerson
  ): zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly = new Wrapper(
    impl
  )
}
