package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModerationLabel(
    confidence: Optional[Percent] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    parentName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ModerationLabel = {
    import ModerationLabel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ModerationLabel
      .builder()
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(parentName.map(value => value: java.lang.String))(
        _.parentName
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ModerationLabel.ReadOnly =
    zio.aws.rekognition.model.ModerationLabel.wrap(buildAwsValue())
}
object ModerationLabel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ModerationLabel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ModerationLabel =
      zio.aws.rekognition.model.ModerationLabel(
        confidence.map(value => value),
        name.map(value => value),
        parentName.map(value => value)
      )
    def confidence: Optional[Percent]
    def name: Optional[String]
    def parentName: Optional[String]
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getParentName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentName", parentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ModerationLabel
  ) extends zio.aws.rekognition.model.ModerationLabel.ReadOnly {
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val parentName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parentName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ModerationLabel
  ): zio.aws.rekognition.model.ModerationLabel.ReadOnly = new Wrapper(impl)
}
