package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IndexFacesResponse(
    faceRecords: Optional[Iterable[zio.aws.rekognition.model.FaceRecord]] =
      Optional.Absent,
    orientationCorrection: Optional[
      zio.aws.rekognition.model.OrientationCorrection
    ] = Optional.Absent,
    faceModelVersion: Optional[String] = Optional.Absent,
    unindexedFaces: Optional[
      Iterable[zio.aws.rekognition.model.UnindexedFace]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.IndexFacesResponse = {
    import IndexFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.IndexFacesResponse
      .builder()
      .optionallyWith(
        faceRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faceRecords)
      .optionallyWith(orientationCorrection.map(value => value.unwrap))(
        _.orientationCorrection
      )
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .optionallyWith(
        unindexedFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unindexedFaces)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.IndexFacesResponse.ReadOnly =
    zio.aws.rekognition.model.IndexFacesResponse.wrap(buildAwsValue())
}
object IndexFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.IndexFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.IndexFacesResponse =
      zio.aws.rekognition.model.IndexFacesResponse(
        faceRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orientationCorrection.map(value => value),
        faceModelVersion.map(value => value),
        unindexedFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def faceRecords
        : Optional[List[zio.aws.rekognition.model.FaceRecord.ReadOnly]]
    def orientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection]
    def faceModelVersion: Optional[String]
    def unindexedFaces
        : Optional[List[zio.aws.rekognition.model.UnindexedFace.ReadOnly]]
    def getFaceRecords: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("faceRecords", faceRecords)
    def getOrientationCorrection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OrientationCorrection] =
      AwsError.unwrapOptionField("orientationCorrection", orientationCorrection)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
    def getUnindexedFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UnindexedFace.ReadOnly
    ]] = AwsError.unwrapOptionField("unindexedFaces", unindexedFaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.IndexFacesResponse
  ) extends zio.aws.rekognition.model.IndexFacesResponse.ReadOnly {
    override val faceRecords
        : Optional[List[zio.aws.rekognition.model.FaceRecord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceRecords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.FaceRecord.wrap(item)
          }.toList
        )
    override val orientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orientationCorrection())
        .map(value =>
          zio.aws.rekognition.model.OrientationCorrection.wrap(value)
        )
    override val faceModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.faceModelVersion())
      .map(value => value: String)
    override val unindexedFaces
        : Optional[List[zio.aws.rekognition.model.UnindexedFace.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unindexedFaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.UnindexedFace.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.IndexFacesResponse
  ): zio.aws.rekognition.model.IndexFacesResponse.ReadOnly = new Wrapper(impl)
}
