package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{PaginationToken, MaxResults, JobId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetPersonTrackingRequest(
    jobId: JobId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.rekognition.model.PersonTrackingSortBy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest = {
    import GetPersonTrackingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetPersonTrackingRequest.ReadOnly =
    zio.aws.rekognition.model.GetPersonTrackingRequest.wrap(buildAwsValue())
}
object GetPersonTrackingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetPersonTrackingRequest =
      zio.aws.rekognition.model.GetPersonTrackingRequest(
        jobId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value)
      )
    def jobId: JobId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.rekognition.model.PersonTrackingSortBy]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.rekognition.model.PersonTrackingSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest
  ) extends zio.aws.rekognition.model.GetPersonTrackingRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.rekognition.model.primitives.JobId(impl.jobId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val sortBy
        : Optional[zio.aws.rekognition.model.PersonTrackingSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.rekognition.model.PersonTrackingSortBy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest
  ): zio.aws.rekognition.model.GetPersonTrackingRequest.ReadOnly = new Wrapper(
    impl
  )
}
