package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLabelDetectionRequestMetadata(
    sortBy: Optional[zio.aws.rekognition.model.LabelDetectionSortBy] =
      Optional.Absent,
    aggregateBy: Optional[zio.aws.rekognition.model.LabelDetectionAggregateBy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequestMetadata = {
    import GetLabelDetectionRequestMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequestMetadata
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(aggregateBy.map(value => value.unwrap))(_.aggregateBy)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetLabelDetectionRequestMetadata.ReadOnly =
    zio.aws.rekognition.model.GetLabelDetectionRequestMetadata
      .wrap(buildAwsValue())
}
object GetLabelDetectionRequestMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequestMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetLabelDetectionRequestMetadata =
      zio.aws.rekognition.model.GetLabelDetectionRequestMetadata(
        sortBy.map(value => value),
        aggregateBy.map(value => value)
      )
    def sortBy: Optional[zio.aws.rekognition.model.LabelDetectionSortBy]
    def aggregateBy
        : Optional[zio.aws.rekognition.model.LabelDetectionAggregateBy]
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.rekognition.model.LabelDetectionSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getAggregateBy: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.LabelDetectionAggregateBy
    ] = AwsError.unwrapOptionField("aggregateBy", aggregateBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequestMetadata
  ) extends zio.aws.rekognition.model.GetLabelDetectionRequestMetadata.ReadOnly {
    override val sortBy
        : Optional[zio.aws.rekognition.model.LabelDetectionSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.rekognition.model.LabelDetectionSortBy.wrap(value)
        )
    override val aggregateBy
        : Optional[zio.aws.rekognition.model.LabelDetectionAggregateBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregateBy())
        .map(value =>
          zio.aws.rekognition.model.LabelDetectionAggregateBy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequestMetadata
  ): zio.aws.rekognition.model.GetLabelDetectionRequestMetadata.ReadOnly =
    new Wrapper(impl)
}
