package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, LivenessSessionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFaceLivenessSessionResultsResponse(
    sessionId: LivenessSessionId,
    status: zio.aws.rekognition.model.LivenessSessionStatus,
    confidence: Optional[Percent] = Optional.Absent,
    referenceImage: Optional[zio.aws.rekognition.model.AuditImage] =
      Optional.Absent,
    auditImages: Optional[Iterable[zio.aws.rekognition.model.AuditImage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsResponse = {
    import GetFaceLivenessSessionResultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsResponse
      .builder()
      .sessionId(LivenessSessionId.unwrap(sessionId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(referenceImage.map(value => value.buildAwsValue()))(
        _.referenceImage
      )
      .optionallyWith(
        auditImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.auditImages)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.ReadOnly =
    zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse
      .wrap(buildAwsValue())
}
object GetFaceLivenessSessionResultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse =
      zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse(
        sessionId,
        status,
        confidence.map(value => value),
        referenceImage.map(value => value.asEditable),
        auditImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sessionId: LivenessSessionId
    def status: zio.aws.rekognition.model.LivenessSessionStatus
    def confidence: Optional[Percent]
    def referenceImage: Optional[zio.aws.rekognition.model.AuditImage.ReadOnly]
    def auditImages
        : Optional[List[zio.aws.rekognition.model.AuditImage.ReadOnly]]
    def getSessionId: ZIO[Any, Nothing, LivenessSessionId] =
      ZIO.succeed(sessionId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.rekognition.model.LivenessSessionStatus] =
      ZIO.succeed(status)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getReferenceImage
        : ZIO[Any, AwsError, zio.aws.rekognition.model.AuditImage.ReadOnly] =
      AwsError.unwrapOptionField("referenceImage", referenceImage)
    def getAuditImages: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.AuditImage.ReadOnly
    ]] = AwsError.unwrapOptionField("auditImages", auditImages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsResponse
  ) extends zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.ReadOnly {
    override val sessionId: LivenessSessionId =
      zio.aws.rekognition.model.primitives.LivenessSessionId(impl.sessionId())
    override val status: zio.aws.rekognition.model.LivenessSessionStatus =
      zio.aws.rekognition.model.LivenessSessionStatus.wrap(impl.status())
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val referenceImage
        : Optional[zio.aws.rekognition.model.AuditImage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceImage())
        .map(value => zio.aws.rekognition.model.AuditImage.wrap(value))
    override val auditImages
        : Optional[List[zio.aws.rekognition.model.AuditImage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditImages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.AuditImage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsResponse
  ): zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.ReadOnly =
    new Wrapper(impl)
}
