package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.LivenessSessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFaceLivenessSessionResultsRequest(
    sessionId: LivenessSessionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsRequest = {
    import GetFaceLivenessSessionResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsRequest
      .builder()
      .sessionId(LivenessSessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest.ReadOnly =
    zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest
      .wrap(buildAwsValue())
}
object GetFaceLivenessSessionResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest =
      zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest(sessionId)
    def sessionId: LivenessSessionId
    def getSessionId: ZIO[Any, Nothing, LivenessSessionId] =
      ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsRequest
  ) extends zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest.ReadOnly {
    override val sessionId: LivenessSessionId =
      zio.aws.rekognition.model.primitives.LivenessSessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsRequest
  ): zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest.ReadOnly =
    new Wrapper(impl)
}
