package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  JobId,
  PaginationToken,
  StatusMessage
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContentModerationResponse(
    jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    videoMetadata: Optional[zio.aws.rekognition.model.VideoMetadata] =
      Optional.Absent,
    moderationLabels: Optional[
      Iterable[zio.aws.rekognition.model.ContentModerationDetection]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    moderationModelVersion: Optional[String] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    video: Optional[zio.aws.rekognition.model.Video] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent,
    getRequestMetadata: Optional[
      zio.aws.rekognition.model.GetContentModerationRequestMetadata
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse = {
    import GetContentModerationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        moderationLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.moderationLabels)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        moderationModelVersion.map(value => value: java.lang.String)
      )(_.moderationModelVersion)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(getRequestMetadata.map(value => value.buildAwsValue()))(
        _.getRequestMetadata
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly =
    zio.aws.rekognition.model.GetContentModerationResponse.wrap(buildAwsValue())
}
object GetContentModerationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetContentModerationResponse =
      zio.aws.rekognition.model.GetContentModerationResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        moderationLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        moderationModelVersion.map(value => value),
        jobId.map(value => value),
        video.map(value => value.asEditable),
        jobTag.map(value => value),
        getRequestMetadata.map(value => value.asEditable)
      )
    def jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Optional[StatusMessage]
    def videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def moderationLabels: Optional[
      List[zio.aws.rekognition.model.ContentModerationDetection.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def moderationModelVersion: Optional[String]
    def jobId: Optional[JobId]
    def video: Optional[zio.aws.rekognition.model.Video.ReadOnly]
    def jobTag: Optional[JobTag]
    def getRequestMetadata: Optional[
      zio.aws.rekognition.model.GetContentModerationRequestMetadata.ReadOnly
    ]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getModerationLabels: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ContentModerationDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("moderationLabels", moderationLabels)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModerationModelVersion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("moderationModelVersion", moderationModelVersion)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getVideo: ZIO[Any, AwsError, zio.aws.rekognition.model.Video.ReadOnly] =
      AwsError.unwrapOptionField("video", video)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getGetRequestMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GetContentModerationRequestMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("getRequestMetadata", getRequestMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse
  ) extends zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly {
    override val jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.videoMetadata())
        .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val moderationLabels: Optional[
      List[zio.aws.rekognition.model.ContentModerationDetection.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.moderationLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ContentModerationDetection.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val moderationModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moderationModelVersion())
        .map(value => value: String)
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
    override val video: Optional[zio.aws.rekognition.model.Video.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.video())
        .map(value => zio.aws.rekognition.model.Video.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
    override val getRequestMetadata: Optional[
      zio.aws.rekognition.model.GetContentModerationRequestMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.getRequestMetadata())
      .map(value =>
        zio.aws.rekognition.model.GetContentModerationRequestMetadata
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse
  ): zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly =
    new Wrapper(impl)
}
