package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContentModerationRequestMetadata(
    sortBy: Optional[zio.aws.rekognition.model.ContentModerationSortBy] =
      Optional.Absent,
    aggregateBy: Optional[
      zio.aws.rekognition.model.ContentModerationAggregateBy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetContentModerationRequestMetadata = {
    import GetContentModerationRequestMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetContentModerationRequestMetadata
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(aggregateBy.map(value => value.unwrap))(_.aggregateBy)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetContentModerationRequestMetadata.ReadOnly =
    zio.aws.rekognition.model.GetContentModerationRequestMetadata
      .wrap(buildAwsValue())
}
object GetContentModerationRequestMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetContentModerationRequestMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.GetContentModerationRequestMetadata =
      zio.aws.rekognition.model.GetContentModerationRequestMetadata(
        sortBy.map(value => value),
        aggregateBy.map(value => value)
      )
    def sortBy: Optional[zio.aws.rekognition.model.ContentModerationSortBy]
    def aggregateBy
        : Optional[zio.aws.rekognition.model.ContentModerationAggregateBy]
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ContentModerationSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getAggregateBy: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ContentModerationAggregateBy
    ] = AwsError.unwrapOptionField("aggregateBy", aggregateBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetContentModerationRequestMetadata
  ) extends zio.aws.rekognition.model.GetContentModerationRequestMetadata.ReadOnly {
    override val sortBy
        : Optional[zio.aws.rekognition.model.ContentModerationSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.rekognition.model.ContentModerationSortBy.wrap(value)
        )
    override val aggregateBy
        : Optional[zio.aws.rekognition.model.ContentModerationAggregateBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregateBy())
        .map(value =>
          zio.aws.rekognition.model.ContentModerationAggregateBy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetContentModerationRequestMetadata
  ): zio.aws.rekognition.model.GetContentModerationRequestMetadata.ReadOnly =
    new Wrapper(impl)
}
