package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{PaginationToken, MaxResults, JobId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetContentModerationRequest(
    jobId: JobId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.rekognition.model.ContentModerationSortBy] =
      Optional.Absent,
    aggregateBy: Optional[
      zio.aws.rekognition.model.ContentModerationAggregateBy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest = {
    import GetContentModerationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(aggregateBy.map(value => value.unwrap))(_.aggregateBy)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetContentModerationRequest.ReadOnly =
    zio.aws.rekognition.model.GetContentModerationRequest.wrap(buildAwsValue())
}
object GetContentModerationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetContentModerationRequest =
      zio.aws.rekognition.model.GetContentModerationRequest(
        jobId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        aggregateBy.map(value => value)
      )
    def jobId: JobId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.rekognition.model.ContentModerationSortBy]
    def aggregateBy
        : Optional[zio.aws.rekognition.model.ContentModerationAggregateBy]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ContentModerationSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getAggregateBy: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ContentModerationAggregateBy
    ] = AwsError.unwrapOptionField("aggregateBy", aggregateBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest
  ) extends zio.aws.rekognition.model.GetContentModerationRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.rekognition.model.primitives.JobId(impl.jobId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val sortBy
        : Optional[zio.aws.rekognition.model.ContentModerationSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.rekognition.model.ContentModerationSortBy.wrap(value)
        )
    override val aggregateBy
        : Optional[zio.aws.rekognition.model.ContentModerationAggregateBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregateBy())
        .map(value =>
          zio.aws.rekognition.model.ContentModerationAggregateBy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest
  ): zio.aws.rekognition.model.GetContentModerationRequest.ReadOnly =
    new Wrapper(impl)
}
