package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, Degree}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EyeDirection(
    yaw: Optional[Degree] = Optional.Absent,
    pitch: Optional[Degree] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.EyeDirection = {
    import EyeDirection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.EyeDirection
      .builder()
      .optionallyWith(yaw.map(value => Degree.unwrap(value): java.lang.Float))(
        _.yaw
      )
      .optionallyWith(
        pitch.map(value => Degree.unwrap(value): java.lang.Float)
      )(_.pitch)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.EyeDirection.ReadOnly =
    zio.aws.rekognition.model.EyeDirection.wrap(buildAwsValue())
}
object EyeDirection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.EyeDirection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.EyeDirection =
      zio.aws.rekognition.model.EyeDirection(
        yaw.map(value => value),
        pitch.map(value => value),
        confidence.map(value => value)
      )
    def yaw: Optional[Degree]
    def pitch: Optional[Degree]
    def confidence: Optional[Percent]
    def getYaw: ZIO[Any, AwsError, Degree] =
      AwsError.unwrapOptionField("yaw", yaw)
    def getPitch: ZIO[Any, AwsError, Degree] =
      AwsError.unwrapOptionField("pitch", pitch)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.EyeDirection
  ) extends zio.aws.rekognition.model.EyeDirection.ReadOnly {
    override val yaw: Optional[Degree] = zio.aws.core.internal
      .optionalFromNullable(impl.yaw())
      .map(value => zio.aws.rekognition.model.primitives.Degree(value))
    override val pitch: Optional[Degree] = zio.aws.core.internal
      .optionalFromNullable(impl.pitch())
      .map(value => zio.aws.rekognition.model.primitives.Degree(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.EyeDirection
  ): zio.aws.rekognition.model.EyeDirection.ReadOnly = new Wrapper(impl)
}
