package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationResult(
    f1Score: Optional[Float] = Optional.Absent,
    summary: Optional[zio.aws.rekognition.model.Summary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.EvaluationResult = {
    import EvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.EvaluationResult
      .builder()
      .optionallyWith(f1Score.map(value => value: java.lang.Float))(_.f1Score)
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.EvaluationResult.ReadOnly =
    zio.aws.rekognition.model.EvaluationResult.wrap(buildAwsValue())
}
object EvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.EvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.EvaluationResult =
      zio.aws.rekognition.model.EvaluationResult(
        f1Score.map(value => value),
        summary.map(value => value.asEditable)
      )
    def f1Score: Optional[Float]
    def summary: Optional[zio.aws.rekognition.model.Summary.ReadOnly]
    def getF1Score: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("f1Score", f1Score)
    def getSummary
        : ZIO[Any, AwsError, zio.aws.rekognition.model.Summary.ReadOnly] =
      AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.EvaluationResult
  ) extends zio.aws.rekognition.model.EvaluationResult.ReadOnly {
    override val f1Score: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.f1Score())
      .map(value => value: Float)
    override val summary: Optional[zio.aws.rekognition.model.Summary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summary())
        .map(value => zio.aws.rekognition.model.Summary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.EvaluationResult
  ): zio.aws.rekognition.model.EvaluationResult.ReadOnly = new Wrapper(impl)
}
