package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Emotion(
    `type`: Optional[zio.aws.rekognition.model.EmotionName] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Emotion = {
    import Emotion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Emotion
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Emotion.ReadOnly =
    zio.aws.rekognition.model.Emotion.wrap(buildAwsValue())
}
object Emotion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Emotion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Emotion =
      zio.aws.rekognition.model
        .Emotion(`type`.map(value => value), confidence.map(value => value))
    def `type`: Optional[zio.aws.rekognition.model.EmotionName]
    def confidence: Optional[Percent]
    def getType: ZIO[Any, AwsError, zio.aws.rekognition.model.EmotionName] =
      AwsError.unwrapOptionField("type", `type`)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Emotion
  ) extends zio.aws.rekognition.model.Emotion.ReadOnly {
    override val `type`: Optional[zio.aws.rekognition.model.EmotionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.rekognition.model.EmotionName.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Emotion
  ): zio.aws.rekognition.model.Emotion.ReadOnly = new Wrapper(impl)
}
