package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectLabelsSettings(
    generalLabels: Optional[zio.aws.rekognition.model.GeneralLabelsSettings] =
      Optional.Absent,
    imageProperties: Optional[
      zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsSettings = {
    import DetectLabelsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsSettings
      .builder()
      .optionallyWith(generalLabels.map(value => value.buildAwsValue()))(
        _.generalLabels
      )
      .optionallyWith(imageProperties.map(value => value.buildAwsValue()))(
        _.imageProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectLabelsSettings.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsSettings.wrap(buildAwsValue())
}
object DetectLabelsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsSettings =
      zio.aws.rekognition.model.DetectLabelsSettings(
        generalLabels.map(value => value.asEditable),
        imageProperties.map(value => value.asEditable)
      )
    def generalLabels
        : Optional[zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly]
    def imageProperties: Optional[
      zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings.ReadOnly
    ]
    def getGeneralLabels: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("generalLabels", generalLabels)
    def getImageProperties: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings.ReadOnly
    ] = AwsError.unwrapOptionField("imageProperties", imageProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsSettings
  ) extends zio.aws.rekognition.model.DetectLabelsSettings.ReadOnly {
    override val generalLabels
        : Optional[zio.aws.rekognition.model.GeneralLabelsSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.generalLabels())
        .map(value =>
          zio.aws.rekognition.model.GeneralLabelsSettings.wrap(value)
        )
    override val imageProperties: Optional[
      zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageProperties())
      .map(value =>
        zio.aws.rekognition.model.DetectLabelsImagePropertiesSettings
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsSettings
  ): zio.aws.rekognition.model.DetectLabelsSettings.ReadOnly = new Wrapper(impl)
}
