package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait DatasetStatus {
  def unwrap: software.amazon.awssdk.services.rekognition.model.DatasetStatus
}
object DatasetStatus {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.DatasetStatus
  ): zio.aws.rekognition.model.DatasetStatus = value match {
    case software.amazon.awssdk.services.rekognition.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatus.UPDATE_COMPLETE =>
      val r = UPDATE_COMPLETE
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatus =
      software.amazon.awssdk.services.rekognition.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.rekognition.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatus =
      software.amazon.awssdk.services.rekognition.model.DatasetStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_COMPLETE extends zio.aws.rekognition.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatus =
      software.amazon.awssdk.services.rekognition.model.DatasetStatus.CREATE_COMPLETE
  }
  case object CREATE_FAILED extends zio.aws.rekognition.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatus =
      software.amazon.awssdk.services.rekognition.model.DatasetStatus.CREATE_FAILED
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.rekognition.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatus =
      software.amazon.awssdk.services.rekognition.model.DatasetStatus.UPDATE_IN_PROGRESS
  }
  case object UPDATE_COMPLETE extends zio.aws.rekognition.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatus =
      software.amazon.awssdk.services.rekognition.model.DatasetStatus.UPDATE_COMPLETE
  }
  case object UPDATE_FAILED extends zio.aws.rekognition.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatus =
      software.amazon.awssdk.services.rekognition.model.DatasetStatus.UPDATE_FAILED
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.rekognition.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetStatus =
      software.amazon.awssdk.services.rekognition.model.DatasetStatus.DELETE_IN_PROGRESS
  }
}
