package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectVersionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateProjectVersionResponse(
    projectVersionArn: Optional[ProjectVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateProjectVersionResponse = {
    import CreateProjectVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateProjectVersionResponse
      .builder()
      .optionallyWith(
        projectVersionArn.map(value =>
          ProjectVersionArn.unwrap(value): java.lang.String
        )
      )(_.projectVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CreateProjectVersionResponse.ReadOnly =
    zio.aws.rekognition.model.CreateProjectVersionResponse.wrap(buildAwsValue())
}
object CreateProjectVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateProjectVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateProjectVersionResponse =
      zio.aws.rekognition.model
        .CreateProjectVersionResponse(projectVersionArn.map(value => value))
    def projectVersionArn: Optional[ProjectVersionArn]
    def getProjectVersionArn: ZIO[Any, AwsError, ProjectVersionArn] =
      AwsError.unwrapOptionField("projectVersionArn", projectVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateProjectVersionResponse
  ) extends zio.aws.rekognition.model.CreateProjectVersionResponse.ReadOnly {
    override val projectVersionArn: Optional[ProjectVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectVersionArn())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateProjectVersionResponse
  ): zio.aws.rekognition.model.CreateProjectVersionResponse.ReadOnly =
    new Wrapper(impl)
}
