package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.LivenessSessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateFaceLivenessSessionResponse(
    sessionId: LivenessSessionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionResponse = {
    import CreateFaceLivenessSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionResponse
      .builder()
      .sessionId(LivenessSessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.ReadOnly =
    zio.aws.rekognition.model.CreateFaceLivenessSessionResponse
      .wrap(buildAwsValue())
}
object CreateFaceLivenessSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.CreateFaceLivenessSessionResponse =
      zio.aws.rekognition.model.CreateFaceLivenessSessionResponse(sessionId)
    def sessionId: LivenessSessionId
    def getSessionId: ZIO[Any, Nothing, LivenessSessionId] =
      ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionResponse
  ) extends zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.ReadOnly {
    override val sessionId: LivenessSessionId =
      zio.aws.rekognition.model.primitives.LivenessSessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionResponse
  ): zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.ReadOnly =
    new Wrapper(impl)
}
