package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.AuditImagesLimit
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateFaceLivenessSessionRequestSettings(
    outputConfig: Optional[zio.aws.rekognition.model.LivenessOutputConfig] =
      Optional.Absent,
    auditImagesLimit: Optional[AuditImagesLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequestSettings = {
    import CreateFaceLivenessSessionRequestSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequestSettings
      .builder()
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        auditImagesLimit.map(value => AuditImagesLimit.unwrap(value): Integer)
      )(_.auditImagesLimit)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings.ReadOnly =
    zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings
      .wrap(buildAwsValue())
}
object CreateFaceLivenessSessionRequestSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequestSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings =
      zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings(
        outputConfig.map(value => value.asEditable),
        auditImagesLimit.map(value => value)
      )
    def outputConfig
        : Optional[zio.aws.rekognition.model.LivenessOutputConfig.ReadOnly]
    def auditImagesLimit: Optional[AuditImagesLimit]
    def getOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.LivenessOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getAuditImagesLimit: ZIO[Any, AwsError, AuditImagesLimit] =
      AwsError.unwrapOptionField("auditImagesLimit", auditImagesLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequestSettings
  ) extends zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings.ReadOnly {
    override val outputConfig
        : Optional[zio.aws.rekognition.model.LivenessOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputConfig())
        .map(value =>
          zio.aws.rekognition.model.LivenessOutputConfig.wrap(value)
        )
    override val auditImagesLimit: Optional[AuditImagesLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditImagesLimit())
        .map(value =>
          zio.aws.rekognition.model.primitives.AuditImagesLimit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequestSettings
  ): zio.aws.rekognition.model.CreateFaceLivenessSessionRequestSettings.ReadOnly =
    new Wrapper(impl)
}
