package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectVersionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyProjectVersionResponse(
    projectVersionArn: Optional[ProjectVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CopyProjectVersionResponse = {
    import CopyProjectVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CopyProjectVersionResponse
      .builder()
      .optionallyWith(
        projectVersionArn.map(value =>
          ProjectVersionArn.unwrap(value): java.lang.String
        )
      )(_.projectVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CopyProjectVersionResponse.ReadOnly =
    zio.aws.rekognition.model.CopyProjectVersionResponse.wrap(buildAwsValue())
}
object CopyProjectVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CopyProjectVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CopyProjectVersionResponse =
      zio.aws.rekognition.model
        .CopyProjectVersionResponse(projectVersionArn.map(value => value))
    def projectVersionArn: Optional[ProjectVersionArn]
    def getProjectVersionArn: ZIO[Any, AwsError, ProjectVersionArn] =
      AwsError.unwrapOptionField("projectVersionArn", projectVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CopyProjectVersionResponse
  ) extends zio.aws.rekognition.model.CopyProjectVersionResponse.ReadOnly {
    override val projectVersionArn: Optional[ProjectVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectVersionArn())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CopyProjectVersionResponse
  ): zio.aws.rekognition.model.CopyProjectVersionResponse.ReadOnly =
    new Wrapper(impl)
}
