package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, RekognitionUniqueId, Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Celebrity(
    urls: Optional[Iterable[Url]] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    id: Optional[RekognitionUniqueId] = Optional.Absent,
    face: Optional[zio.aws.rekognition.model.ComparedFace] = Optional.Absent,
    matchConfidence: Optional[Percent] = Optional.Absent,
    knownGender: Optional[zio.aws.rekognition.model.KnownGender] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Celebrity = {
    import Celebrity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Celebrity
      .builder()
      .optionallyWith(
        urls.map(value =>
          value.map { item =>
            Url.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.urls)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        id.map(value => RekognitionUniqueId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .optionallyWith(
        matchConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.matchConfidence)
      .optionallyWith(knownGender.map(value => value.buildAwsValue()))(
        _.knownGender
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Celebrity.ReadOnly =
    zio.aws.rekognition.model.Celebrity.wrap(buildAwsValue())
}
object Celebrity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Celebrity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Celebrity =
      zio.aws.rekognition.model.Celebrity(
        urls.map(value => value),
        name.map(value => value),
        id.map(value => value),
        face.map(value => value.asEditable),
        matchConfidence.map(value => value),
        knownGender.map(value => value.asEditable)
      )
    def urls: Optional[List[Url]]
    def name: Optional[String]
    def id: Optional[RekognitionUniqueId]
    def face: Optional[zio.aws.rekognition.model.ComparedFace.ReadOnly]
    def matchConfidence: Optional[Percent]
    def knownGender: Optional[zio.aws.rekognition.model.KnownGender.ReadOnly]
    def getUrls: ZIO[Any, AwsError, List[Url]] =
      AwsError.unwrapOptionField("urls", urls)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, RekognitionUniqueId] =
      AwsError.unwrapOptionField("id", id)
    def getFace
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ComparedFace.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
    def getMatchConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("matchConfidence", matchConfidence)
    def getKnownGender
        : ZIO[Any, AwsError, zio.aws.rekognition.model.KnownGender.ReadOnly] =
      AwsError.unwrapOptionField("knownGender", knownGender)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Celebrity
  ) extends zio.aws.rekognition.model.Celebrity.ReadOnly {
    override val urls: Optional[List[Url]] = zio.aws.core.internal
      .optionalFromNullable(impl.urls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.Url(item)
        }.toList
      )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val id: Optional[RekognitionUniqueId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.rekognition.model.primitives.RekognitionUniqueId(value)
      )
    override val face
        : Optional[zio.aws.rekognition.model.ComparedFace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.face())
        .map(value => zio.aws.rekognition.model.ComparedFace.wrap(value))
    override val matchConfidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.matchConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val knownGender
        : Optional[zio.aws.rekognition.model.KnownGender.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.knownGender())
        .map(value => zio.aws.rekognition.model.KnownGender.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Celebrity
  ): zio.aws.rekognition.model.Celebrity.ReadOnly = new Wrapper(impl)
}
