package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.LivenessImageBlob
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuditImage(
    bytes: Optional[LivenessImageBlob] = Optional.Absent,
    s3Object: Optional[zio.aws.rekognition.model.S3Object] = Optional.Absent,
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.AuditImage = {
    import AuditImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.AuditImage
      .builder()
      .optionallyWith(
        bytes.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.bytes)
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.AuditImage.ReadOnly =
    zio.aws.rekognition.model.AuditImage.wrap(buildAwsValue())
}
object AuditImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.AuditImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.AuditImage =
      zio.aws.rekognition.model.AuditImage(
        bytes.map(value => value),
        s3Object.map(value => value.asEditable),
        boundingBox.map(value => value.asEditable)
      )
    def bytes: Optional[LivenessImageBlob]
    def s3Object: Optional[zio.aws.rekognition.model.S3Object.ReadOnly]
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def getBytes: ZIO[Any, AwsError, LivenessImageBlob] =
      AwsError.unwrapOptionField("bytes", bytes)
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.rekognition.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.AuditImage
  ) extends zio.aws.rekognition.model.AuditImage.ReadOnly {
    override val bytes: Optional[LivenessImageBlob] = zio.aws.core.internal
      .optionalFromNullable(impl.bytes())
      .map(value =>
        zio.aws.rekognition.model.primitives
          .LivenessImageBlob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val s3Object
        : Optional[zio.aws.rekognition.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Object())
        .map(value => zio.aws.rekognition.model.S3Object.wrap(value))
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.AuditImage
  ): zio.aws.rekognition.model.AuditImage.ReadOnly = new Wrapper(impl)
}
