package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Asset(
    groundTruthManifest: Optional[
      zio.aws.rekognition.model.GroundTruthManifest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Asset = {
    import Asset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Asset
      .builder()
      .optionallyWith(groundTruthManifest.map(value => value.buildAwsValue()))(
        _.groundTruthManifest
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Asset.ReadOnly =
    zio.aws.rekognition.model.Asset.wrap(buildAwsValue())
}
object Asset {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Asset] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Asset = zio.aws.rekognition.model
      .Asset(groundTruthManifest.map(value => value.asEditable))
    def groundTruthManifest
        : Optional[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly]
    def getGroundTruthManifest: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GroundTruthManifest.ReadOnly
    ] = AwsError.unwrapOptionField("groundTruthManifest", groundTruthManifest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Asset
  ) extends zio.aws.rekognition.model.Asset.ReadOnly {
    override val groundTruthManifest
        : Optional[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groundTruthManifest())
        .map(value => zio.aws.rekognition.model.GroundTruthManifest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Asset
  ): zio.aws.rekognition.model.Asset.ReadOnly = new Wrapper(impl)
}
