package zio.aws.rekognition
import zio.aws.rekognition.model.DescribeProjectsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.rekognition.paginators.ListCollectionsPublisher
import software.amazon.awssdk.services.rekognition.model.{
  Face,
  CreateCollectionResponse,
  DeleteStreamProcessorRequest,
  DescribeProjectVersionsResponse,
  StartPersonTrackingRequest,
  GetSegmentDetectionResponse,
  DetectLabelsResponse,
  FaceDetection,
  ListCollectionsResponse,
  GetCelebrityInfoResponse,
  StartFaceSearchRequest,
  CopyProjectVersionResponse,
  UpdateStreamProcessorResponse,
  CreateCollectionRequest,
  DescribeDatasetResponse,
  DescribeCollectionResponse,
  StopStreamProcessorRequest,
  DeleteProjectPolicyRequest,
  CreateDatasetRequest,
  GetFaceLivenessSessionResultsResponse,
  DetectCustomLabelsRequest,
  StartFaceDetectionResponse,
  CompareFacesRequest,
  DeleteCollectionRequest,
  DetectProtectiveEquipmentRequest,
  CreateProjectRequest,
  DeleteFacesResponse,
  DetectLabelsRequest,
  StopProjectVersionResponse,
  DescribeProjectsRequest,
  GetFaceDetectionRequest,
  DescribeStreamProcessorRequest,
  StartLabelDetectionResponse,
  StartFaceSearchResponse,
  DeleteFacesRequest,
  DatasetLabelDescription,
  GetCelebrityInfoRequest,
  StartProjectVersionRequest,
  UpdateStreamProcessorRequest,
  DetectCustomLabelsResponse,
  CreateStreamProcessorResponse,
  DescribeStreamProcessorResponse,
  GetSegmentDetectionRequest,
  StartPersonTrackingResponse,
  DetectTextRequest,
  GetFaceSearchResponse,
  DetectFacesRequest,
  PutProjectPolicyRequest,
  CreateProjectVersionResponse,
  ListFacesRequest,
  CreateFaceLivenessSessionRequest,
  DescribeDatasetRequest,
  StreamProcessor,
  CreateStreamProcessorRequest,
  StartContentModerationResponse,
  DetectModerationLabelsRequest,
  ListTagsForResourceRequest,
  PersonMatch,
  DescribeProjectsResponse,
  DescribeCollectionRequest,
  CreateProjectVersionRequest,
  GetLabelDetectionRequest,
  ProjectDescription,
  CreateDatasetResponse,
  ListStreamProcessorsRequest,
  StartTextDetectionResponse,
  RecognizeCelebritiesResponse,
  DistributeDatasetEntriesRequest,
  GetLabelDetectionResponse,
  ListDatasetEntriesResponse,
  StartStreamProcessorRequest,
  ListTagsForResourceResponse,
  IndexFacesRequest,
  UntagResourceResponse,
  StartCelebrityRecognitionRequest,
  GetPersonTrackingRequest,
  LabelDetection,
  DetectTextResponse,
  ContentModerationDetection,
  DeleteCollectionResponse,
  ListCollectionsRequest,
  DeleteProjectRequest,
  SearchFacesResponse,
  DistributeDatasetEntriesResponse,
  ListDatasetEntriesRequest,
  SearchFacesRequest,
  DeleteProjectPolicyResponse,
  PersonDetection,
  CreateProjectResponse,
  ProjectVersionDescription,
  StartFaceDetectionRequest,
  GetContentModerationRequest,
  DeleteProjectVersionResponse,
  ListFacesResponse,
  GetContentModerationResponse,
  GetFaceLivenessSessionResultsRequest,
  SearchFacesByImageResponse,
  SearchFacesByImageRequest,
  DeleteDatasetRequest,
  StartStreamProcessorResponse,
  GetPersonTrackingResponse,
  DeleteDatasetResponse,
  IndexFacesResponse,
  DetectProtectiveEquipmentResponse,
  GetTextDetectionResponse,
  ProjectPolicy,
  StartProjectVersionResponse,
  StartSegmentDetectionResponse,
  DescribeProjectVersionsRequest,
  RecognizeCelebritiesRequest,
  StartCelebrityRecognitionResponse,
  UntagResourceRequest,
  DetectModerationLabelsResponse,
  UpdateDatasetEntriesRequest,
  StartSegmentDetectionRequest,
  DetectFacesResponse,
  StartLabelDetectionRequest,
  CelebrityRecognition,
  PutProjectPolicyResponse,
  StartContentModerationRequest,
  StopStreamProcessorResponse,
  GetFaceDetectionResponse,
  StartTextDetectionRequest,
  DeleteStreamProcessorResponse,
  ListProjectPoliciesRequest,
  UpdateDatasetEntriesResponse,
  TagResourceResponse,
  ListProjectPoliciesResponse,
  CopyProjectVersionRequest,
  GetCelebrityRecognitionRequest,
  ListDatasetLabelsRequest,
  DeleteProjectResponse,
  CreateFaceLivenessSessionResponse,
  GetFaceSearchRequest,
  ListStreamProcessorsResponse,
  CompareFacesResponse,
  DeleteProjectVersionRequest,
  GetCelebrityRecognitionResponse,
  ListDatasetLabelsResponse,
  StopProjectVersionRequest,
  TagResourceRequest,
  GetTextDetectionRequest,
  TextDetectionResult
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.rekognition.{
  RekognitionAsyncClientBuilder,
  RekognitionAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.rekognition.model.primitives.{CollectionId, DatasetEntry}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Rekognition extends AspectSupport[Rekognition] {
  val api: RekognitionAsyncClient
  def listDatasetEntries(
      request: zio.aws.rekognition.model.ListDatasetEntriesRequest
  ): ZStream[Any, AwsError, DatasetEntry]
  def listDatasetEntriesPaginated(
      request: zio.aws.rekognition.model.ListDatasetEntriesRequest
  ): IO[AwsError, zio.aws.rekognition.model.ListDatasetEntriesResponse.ReadOnly]
  def createDataset(
      request: zio.aws.rekognition.model.CreateDatasetRequest
  ): IO[AwsError, zio.aws.rekognition.model.CreateDatasetResponse.ReadOnly]
  def getSegmentDetection(
      request: zio.aws.rekognition.model.GetSegmentDetectionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly
  ]
  def indexFaces(
      request: zio.aws.rekognition.model.IndexFacesRequest
  ): IO[AwsError, zio.aws.rekognition.model.IndexFacesResponse.ReadOnly]
  def updateStreamProcessor(
      request: zio.aws.rekognition.model.UpdateStreamProcessorRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.UpdateStreamProcessorResponse.ReadOnly
  ]
  def startCelebrityRecognition(
      request: zio.aws.rekognition.model.StartCelebrityRecognitionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.StartCelebrityRecognitionResponse.ReadOnly
  ]
  def distributeDatasetEntries(
      request: zio.aws.rekognition.model.DistributeDatasetEntriesRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.DistributeDatasetEntriesResponse.ReadOnly
  ]
  def detectText(
      request: zio.aws.rekognition.model.DetectTextRequest
  ): IO[AwsError, zio.aws.rekognition.model.DetectTextResponse.ReadOnly]
  def detectCustomLabels(
      request: zio.aws.rekognition.model.DetectCustomLabelsRequest
  ): IO[AwsError, zio.aws.rekognition.model.DetectCustomLabelsResponse.ReadOnly]
  def createProjectVersion(
      request: zio.aws.rekognition.model.CreateProjectVersionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.CreateProjectVersionResponse.ReadOnly
  ]
  def startTextDetection(
      request: zio.aws.rekognition.model.StartTextDetectionRequest
  ): IO[AwsError, zio.aws.rekognition.model.StartTextDetectionResponse.ReadOnly]
  def createCollection(
      request: zio.aws.rekognition.model.CreateCollectionRequest
  ): IO[AwsError, zio.aws.rekognition.model.CreateCollectionResponse.ReadOnly]
  def searchFacesByImage(
      request: zio.aws.rekognition.model.SearchFacesByImageRequest
  ): IO[AwsError, zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly]
  def searchFaces(
      request: zio.aws.rekognition.model.SearchFacesRequest
  ): IO[AwsError, zio.aws.rekognition.model.SearchFacesResponse.ReadOnly]
  def describeProjectVersions(
      request: zio.aws.rekognition.model.DescribeProjectVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly
  ]
  def describeProjectVersionsPaginated(
      request: zio.aws.rekognition.model.DescribeProjectVersionsRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.DescribeProjectVersionsResponse.ReadOnly
  ]
  def startProjectVersion(
      request: zio.aws.rekognition.model.StartProjectVersionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.StartProjectVersionResponse.ReadOnly
  ]
  def deleteCollection(
      request: zio.aws.rekognition.model.DeleteCollectionRequest
  ): IO[AwsError, zio.aws.rekognition.model.DeleteCollectionResponse.ReadOnly]
  def updateDatasetEntries(
      request: zio.aws.rekognition.model.UpdateDatasetEntriesRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.UpdateDatasetEntriesResponse.ReadOnly
  ]
  def describeCollection(
      request: zio.aws.rekognition.model.DescribeCollectionRequest
  ): IO[AwsError, zio.aws.rekognition.model.DescribeCollectionResponse.ReadOnly]
  def getPersonTracking(
      request: zio.aws.rekognition.model.GetPersonTrackingRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly,
    zio.aws.rekognition.model.PersonDetection.ReadOnly
  ]]
  def getPersonTrackingPaginated(
      request: zio.aws.rekognition.model.GetPersonTrackingRequest
  ): IO[AwsError, zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly]
  def getFaceDetection(
      request: zio.aws.rekognition.model.GetFaceDetectionRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly,
    zio.aws.rekognition.model.FaceDetection.ReadOnly
  ]]
  def getFaceDetectionPaginated(
      request: zio.aws.rekognition.model.GetFaceDetectionRequest
  ): IO[AwsError, zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly]
  def describeDataset(
      request: zio.aws.rekognition.model.DescribeDatasetRequest
  ): IO[AwsError, zio.aws.rekognition.model.DescribeDatasetResponse.ReadOnly]
  def detectFaces(
      request: zio.aws.rekognition.model.DetectFacesRequest
  ): IO[AwsError, zio.aws.rekognition.model.DetectFacesResponse.ReadOnly]
  def startFaceSearch(
      request: zio.aws.rekognition.model.StartFaceSearchRequest
  ): IO[AwsError, zio.aws.rekognition.model.StartFaceSearchResponse.ReadOnly]
  def deleteFaces(
      request: zio.aws.rekognition.model.DeleteFacesRequest
  ): IO[AwsError, zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly]
  def listProjectPolicies(
      request: zio.aws.rekognition.model.ListProjectPoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.rekognition.model.ProjectPolicy.ReadOnly]
  def listProjectPoliciesPaginated(
      request: zio.aws.rekognition.model.ListProjectPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.ListProjectPoliciesResponse.ReadOnly
  ]
  def compareFaces(
      request: zio.aws.rekognition.model.CompareFacesRequest
  ): IO[AwsError, zio.aws.rekognition.model.CompareFacesResponse.ReadOnly]
  def getTextDetection(
      request: zio.aws.rekognition.model.GetTextDetectionRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly,
    zio.aws.rekognition.model.TextDetectionResult.ReadOnly
  ]]
  def getTextDetectionPaginated(
      request: zio.aws.rekognition.model.GetTextDetectionRequest
  ): IO[AwsError, zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly]
  def createStreamProcessor(
      request: zio.aws.rekognition.model.CreateStreamProcessorRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.CreateStreamProcessorResponse.ReadOnly
  ]
  def createFaceLivenessSession(
      request: zio.aws.rekognition.model.CreateFaceLivenessSessionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.ReadOnly
  ]
  def describeStreamProcessor(
      request: zio.aws.rekognition.model.DescribeStreamProcessorRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.DescribeStreamProcessorResponse.ReadOnly
  ]
  def detectLabels(
      request: zio.aws.rekognition.model.DetectLabelsRequest
  ): IO[AwsError, zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.rekognition.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.rekognition.model.UntagResourceResponse.ReadOnly]
  def createProject(
      request: zio.aws.rekognition.model.CreateProjectRequest
  ): IO[AwsError, zio.aws.rekognition.model.CreateProjectResponse.ReadOnly]
  def copyProjectVersion(
      request: zio.aws.rekognition.model.CopyProjectVersionRequest
  ): IO[AwsError, zio.aws.rekognition.model.CopyProjectVersionResponse.ReadOnly]
  def deleteStreamProcessor(
      request: zio.aws.rekognition.model.DeleteStreamProcessorRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.DeleteStreamProcessorResponse.ReadOnly
  ]
  def getFaceLivenessSessionResults(
      request: zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.ReadOnly
  ]
  def stopProjectVersion(
      request: zio.aws.rekognition.model.StopProjectVersionRequest
  ): IO[AwsError, zio.aws.rekognition.model.StopProjectVersionResponse.ReadOnly]
  def stopStreamProcessor(
      request: zio.aws.rekognition.model.StopStreamProcessorRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.StopStreamProcessorResponse.ReadOnly
  ]
  def listFaces(
      request: zio.aws.rekognition.model.ListFacesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.ListFacesResponse.ReadOnly,
    zio.aws.rekognition.model.Face.ReadOnly
  ]]
  def listFacesPaginated(
      request: zio.aws.rekognition.model.ListFacesRequest
  ): IO[AwsError, zio.aws.rekognition.model.ListFacesResponse.ReadOnly]
  def putProjectPolicy(
      request: zio.aws.rekognition.model.PutProjectPolicyRequest
  ): IO[AwsError, zio.aws.rekognition.model.PutProjectPolicyResponse.ReadOnly]
  def startStreamProcessor(
      request: zio.aws.rekognition.model.StartStreamProcessorRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.StartStreamProcessorResponse.ReadOnly
  ]
  def startPersonTracking(
      request: zio.aws.rekognition.model.StartPersonTrackingRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.StartPersonTrackingResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.rekognition.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.ListTagsForResourceResponse.ReadOnly
  ]
  def listStreamProcessors(
      request: zio.aws.rekognition.model.ListStreamProcessorsRequest
  ): ZStream[Any, AwsError, zio.aws.rekognition.model.StreamProcessor.ReadOnly]
  def listStreamProcessorsPaginated(
      request: zio.aws.rekognition.model.ListStreamProcessorsRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.ListStreamProcessorsResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.rekognition.model.TagResourceRequest
  ): IO[AwsError, zio.aws.rekognition.model.TagResourceResponse.ReadOnly]
  def listDatasetLabels(
      request: zio.aws.rekognition.model.ListDatasetLabelsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly
  ]
  def listDatasetLabelsPaginated(
      request: zio.aws.rekognition.model.ListDatasetLabelsRequest
  ): IO[AwsError, zio.aws.rekognition.model.ListDatasetLabelsResponse.ReadOnly]
  def detectProtectiveEquipment(
      request: zio.aws.rekognition.model.DetectProtectiveEquipmentRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.ReadOnly
  ]
  def deleteProjectPolicy(
      request: zio.aws.rekognition.model.DeleteProjectPolicyRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.DeleteProjectPolicyResponse.ReadOnly
  ]
  def startFaceDetection(
      request: zio.aws.rekognition.model.StartFaceDetectionRequest
  ): IO[AwsError, zio.aws.rekognition.model.StartFaceDetectionResponse.ReadOnly]
  def listCollections(
      request: zio.aws.rekognition.model.ListCollectionsRequest
  ): ZStream[Any, AwsError, CollectionId]
  def listCollectionsPaginated(
      request: zio.aws.rekognition.model.ListCollectionsRequest
  ): IO[AwsError, zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly]
  def describeProjects(
      request: zio.aws.rekognition.model.DescribeProjectsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.rekognition.model.ProjectDescription.ReadOnly
  ]
  def describeProjectsPaginated(
      request: zio.aws.rekognition.model.DescribeProjectsRequest
  ): IO[AwsError, ReadOnly]
  def getFaceSearch(
      request: zio.aws.rekognition.model.GetFaceSearchRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly,
    zio.aws.rekognition.model.PersonMatch.ReadOnly
  ]]
  def getFaceSearchPaginated(
      request: zio.aws.rekognition.model.GetFaceSearchRequest
  ): IO[AwsError, zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly]
  def detectModerationLabels(
      request: zio.aws.rekognition.model.DetectModerationLabelsRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.DetectModerationLabelsResponse.ReadOnly
  ]
  def startSegmentDetection(
      request: zio.aws.rekognition.model.StartSegmentDetectionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.StartSegmentDetectionResponse.ReadOnly
  ]
  def deleteDataset(
      request: zio.aws.rekognition.model.DeleteDatasetRequest
  ): IO[AwsError, zio.aws.rekognition.model.DeleteDatasetResponse.ReadOnly]
  def startContentModeration(
      request: zio.aws.rekognition.model.StartContentModerationRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.StartContentModerationResponse.ReadOnly
  ]
  def getCelebrityInfo(
      request: zio.aws.rekognition.model.GetCelebrityInfoRequest
  ): IO[AwsError, zio.aws.rekognition.model.GetCelebrityInfoResponse.ReadOnly]
  def deleteProject(
      request: zio.aws.rekognition.model.DeleteProjectRequest
  ): IO[AwsError, zio.aws.rekognition.model.DeleteProjectResponse.ReadOnly]
  def startLabelDetection(
      request: zio.aws.rekognition.model.StartLabelDetectionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.StartLabelDetectionResponse.ReadOnly
  ]
  def recognizeCelebrities(
      request: zio.aws.rekognition.model.RecognizeCelebritiesRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly
  ]
  def getContentModeration(
      request: zio.aws.rekognition.model.GetContentModerationRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly,
    zio.aws.rekognition.model.ContentModerationDetection.ReadOnly
  ]]
  def getContentModerationPaginated(
      request: zio.aws.rekognition.model.GetContentModerationRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly
  ]
  def getLabelDetection(
      request: zio.aws.rekognition.model.GetLabelDetectionRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly,
    zio.aws.rekognition.model.LabelDetection.ReadOnly
  ]]
  def getLabelDetectionPaginated(
      request: zio.aws.rekognition.model.GetLabelDetectionRequest
  ): IO[AwsError, zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly]
  def deleteProjectVersion(
      request: zio.aws.rekognition.model.DeleteProjectVersionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.DeleteProjectVersionResponse.ReadOnly
  ]
  def getCelebrityRecognition(
      request: zio.aws.rekognition.model.GetCelebrityRecognitionRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly,
    zio.aws.rekognition.model.CelebrityRecognition.ReadOnly
  ]]
  def getCelebrityRecognitionPaginated(
      request: zio.aws.rekognition.model.GetCelebrityRecognitionRequest
  ): IO[
    AwsError,
    zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly
  ]
}
object Rekognition {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Rekognition] = customized(
    identity
  )
  def customized(
      customization: RekognitionAsyncClientBuilder => RekognitionAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Rekognition] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: RekognitionAsyncClientBuilder => RekognitionAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Rekognition] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = RekognitionAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[RekognitionAsyncClient, RekognitionAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      RekognitionAsyncClient,
      RekognitionAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new RekognitionImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class RekognitionImpl[R](
      override val api: RekognitionAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Rekognition
      with AwsServiceBase[R] {
    override val serviceName: String = "Rekognition"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RekognitionImpl[R1] = new RekognitionImpl(api, newAspect, r)
    def listDatasetEntries(
        request: zio.aws.rekognition.model.ListDatasetEntriesRequest
    ): ZStream[Any, AwsError, DatasetEntry] = asyncSimplePaginatedRequest[
      ListDatasetEntriesRequest,
      ListDatasetEntriesResponse,
      java.lang.String
    ](
      "listDatasetEntries",
      api.listDatasetEntries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.datasetEntries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.rekognition.model.primitives.DatasetEntry(item))
      .provideEnvironment(r)
    def listDatasetEntriesPaginated(
        request: zio.aws.rekognition.model.ListDatasetEntriesRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.ListDatasetEntriesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDatasetEntriesRequest,
      ListDatasetEntriesResponse
    ]("listDatasetEntries", api.listDatasetEntries)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.ListDatasetEntriesResponse.wrap)
      .provideEnvironment(r)
    def createDataset(
        request: zio.aws.rekognition.model.CreateDatasetRequest
    ): IO[AwsError, zio.aws.rekognition.model.CreateDatasetResponse.ReadOnly] =
      asyncRequestResponse[CreateDatasetRequest, CreateDatasetResponse](
        "createDataset",
        api.createDataset
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.CreateDatasetResponse.wrap)
        .provideEnvironment(r)
    def getSegmentDetection(
        request: zio.aws.rekognition.model.GetSegmentDetectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSegmentDetectionRequest,
      GetSegmentDetectionResponse
    ]("getSegmentDetection", api.getSegmentDetection)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.GetSegmentDetectionResponse.wrap)
      .provideEnvironment(r)
    def indexFaces(
        request: zio.aws.rekognition.model.IndexFacesRequest
    ): IO[AwsError, zio.aws.rekognition.model.IndexFacesResponse.ReadOnly] =
      asyncRequestResponse[IndexFacesRequest, IndexFacesResponse](
        "indexFaces",
        api.indexFaces
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.IndexFacesResponse.wrap)
        .provideEnvironment(r)
    def updateStreamProcessor(
        request: zio.aws.rekognition.model.UpdateStreamProcessorRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.UpdateStreamProcessorResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateStreamProcessorRequest,
      UpdateStreamProcessorResponse
    ]("updateStreamProcessor", api.updateStreamProcessor)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.UpdateStreamProcessorResponse.wrap)
      .provideEnvironment(r)
    def startCelebrityRecognition(
        request: zio.aws.rekognition.model.StartCelebrityRecognitionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartCelebrityRecognitionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartCelebrityRecognitionRequest,
      StartCelebrityRecognitionResponse
    ]("startCelebrityRecognition", api.startCelebrityRecognition)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.StartCelebrityRecognitionResponse.wrap)
      .provideEnvironment(r)
    def distributeDatasetEntries(
        request: zio.aws.rekognition.model.DistributeDatasetEntriesRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DistributeDatasetEntriesResponse.ReadOnly
    ] = asyncRequestResponse[
      DistributeDatasetEntriesRequest,
      DistributeDatasetEntriesResponse
    ]("distributeDatasetEntries", api.distributeDatasetEntries)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.DistributeDatasetEntriesResponse.wrap)
      .provideEnvironment(r)
    def detectText(
        request: zio.aws.rekognition.model.DetectTextRequest
    ): IO[AwsError, zio.aws.rekognition.model.DetectTextResponse.ReadOnly] =
      asyncRequestResponse[DetectTextRequest, DetectTextResponse](
        "detectText",
        api.detectText
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.DetectTextResponse.wrap)
        .provideEnvironment(r)
    def detectCustomLabels(
        request: zio.aws.rekognition.model.DetectCustomLabelsRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DetectCustomLabelsResponse.ReadOnly
    ] = asyncRequestResponse[
      DetectCustomLabelsRequest,
      DetectCustomLabelsResponse
    ]("detectCustomLabels", api.detectCustomLabels)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.DetectCustomLabelsResponse.wrap)
      .provideEnvironment(r)
    def createProjectVersion(
        request: zio.aws.rekognition.model.CreateProjectVersionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.CreateProjectVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateProjectVersionRequest,
      CreateProjectVersionResponse
    ]("createProjectVersion", api.createProjectVersion)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.CreateProjectVersionResponse.wrap)
      .provideEnvironment(r)
    def startTextDetection(
        request: zio.aws.rekognition.model.StartTextDetectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartTextDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartTextDetectionRequest,
      StartTextDetectionResponse
    ]("startTextDetection", api.startTextDetection)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StartTextDetectionResponse.wrap)
      .provideEnvironment(r)
    def createCollection(
        request: zio.aws.rekognition.model.CreateCollectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.CreateCollectionResponse.ReadOnly
    ] = asyncRequestResponse[CreateCollectionRequest, CreateCollectionResponse](
      "createCollection",
      api.createCollection
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.CreateCollectionResponse.wrap)
      .provideEnvironment(r)
    def searchFacesByImage(
        request: zio.aws.rekognition.model.SearchFacesByImageRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchFacesByImageRequest,
      SearchFacesByImageResponse
    ]("searchFacesByImage", api.searchFacesByImage)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.SearchFacesByImageResponse.wrap)
      .provideEnvironment(r)
    def searchFaces(
        request: zio.aws.rekognition.model.SearchFacesRequest
    ): IO[AwsError, zio.aws.rekognition.model.SearchFacesResponse.ReadOnly] =
      asyncRequestResponse[SearchFacesRequest, SearchFacesResponse](
        "searchFaces",
        api.searchFaces
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.SearchFacesResponse.wrap)
        .provideEnvironment(r)
    def describeProjectVersions(
        request: zio.aws.rekognition.model.DescribeProjectVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeProjectVersionsRequest,
      DescribeProjectVersionsResponse,
      ProjectVersionDescription
    ](
      "describeProjectVersions",
      api.describeProjectVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.projectVersionDescriptions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.rekognition.model.ProjectVersionDescription.wrap(item)
      )
      .provideEnvironment(r)
    def describeProjectVersionsPaginated(
        request: zio.aws.rekognition.model.DescribeProjectVersionsRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DescribeProjectVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeProjectVersionsRequest,
      DescribeProjectVersionsResponse
    ]("describeProjectVersions", api.describeProjectVersions)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.DescribeProjectVersionsResponse.wrap)
      .provideEnvironment(r)
    def startProjectVersion(
        request: zio.aws.rekognition.model.StartProjectVersionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartProjectVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartProjectVersionRequest,
      StartProjectVersionResponse
    ]("startProjectVersion", api.startProjectVersion)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StartProjectVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteCollection(
        request: zio.aws.rekognition.model.DeleteCollectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DeleteCollectionResponse.ReadOnly
    ] = asyncRequestResponse[DeleteCollectionRequest, DeleteCollectionResponse](
      "deleteCollection",
      api.deleteCollection
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.DeleteCollectionResponse.wrap)
      .provideEnvironment(r)
    def updateDatasetEntries(
        request: zio.aws.rekognition.model.UpdateDatasetEntriesRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.UpdateDatasetEntriesResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDatasetEntriesRequest,
      UpdateDatasetEntriesResponse
    ]("updateDatasetEntries", api.updateDatasetEntries)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.UpdateDatasetEntriesResponse.wrap)
      .provideEnvironment(r)
    def describeCollection(
        request: zio.aws.rekognition.model.DescribeCollectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DescribeCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCollectionRequest,
      DescribeCollectionResponse
    ]("describeCollection", api.describeCollection)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.DescribeCollectionResponse.wrap)
      .provideEnvironment(r)
    def getPersonTracking(
        request: zio.aws.rekognition.model.GetPersonTrackingRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly,
      zio.aws.rekognition.model.PersonDetection.ReadOnly
    ]] = asyncPaginatedRequest[
      GetPersonTrackingRequest,
      GetPersonTrackingResponse,
      PersonDetection
    ](
      "getPersonTracking",
      api.getPersonTracking,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.persons().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.rekognition.model.GetPersonTrackingResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.rekognition.model.PersonDetection.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getPersonTrackingPaginated(
        request: zio.aws.rekognition.model.GetPersonTrackingRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly
    ] =
      asyncRequestResponse[GetPersonTrackingRequest, GetPersonTrackingResponse](
        "getPersonTracking",
        api.getPersonTracking
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.GetPersonTrackingResponse.wrap)
        .provideEnvironment(r)
    def getFaceDetection(
        request: zio.aws.rekognition.model.GetFaceDetectionRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly,
      zio.aws.rekognition.model.FaceDetection.ReadOnly
    ]] = asyncPaginatedRequest[
      GetFaceDetectionRequest,
      GetFaceDetectionResponse,
      FaceDetection
    ](
      "getFaceDetection",
      api.getFaceDetection,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.faces().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.rekognition.model.GetFaceDetectionResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.rekognition.model.FaceDetection.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getFaceDetectionPaginated(
        request: zio.aws.rekognition.model.GetFaceDetectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly
    ] = asyncRequestResponse[GetFaceDetectionRequest, GetFaceDetectionResponse](
      "getFaceDetection",
      api.getFaceDetection
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.GetFaceDetectionResponse.wrap)
      .provideEnvironment(r)
    def describeDataset(
        request: zio.aws.rekognition.model.DescribeDatasetRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DescribeDatasetResponse.ReadOnly
    ] = asyncRequestResponse[DescribeDatasetRequest, DescribeDatasetResponse](
      "describeDataset",
      api.describeDataset
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.DescribeDatasetResponse.wrap)
      .provideEnvironment(r)
    def detectFaces(
        request: zio.aws.rekognition.model.DetectFacesRequest
    ): IO[AwsError, zio.aws.rekognition.model.DetectFacesResponse.ReadOnly] =
      asyncRequestResponse[DetectFacesRequest, DetectFacesResponse](
        "detectFaces",
        api.detectFaces
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.DetectFacesResponse.wrap)
        .provideEnvironment(r)
    def startFaceSearch(
        request: zio.aws.rekognition.model.StartFaceSearchRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartFaceSearchResponse.ReadOnly
    ] = asyncRequestResponse[StartFaceSearchRequest, StartFaceSearchResponse](
      "startFaceSearch",
      api.startFaceSearch
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StartFaceSearchResponse.wrap)
      .provideEnvironment(r)
    def deleteFaces(
        request: zio.aws.rekognition.model.DeleteFacesRequest
    ): IO[AwsError, zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly] =
      asyncRequestResponse[DeleteFacesRequest, DeleteFacesResponse](
        "deleteFaces",
        api.deleteFaces
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.DeleteFacesResponse.wrap)
        .provideEnvironment(r)
    def listProjectPolicies(
        request: zio.aws.rekognition.model.ListProjectPoliciesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rekognition.model.ProjectPolicy.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListProjectPoliciesRequest,
      ListProjectPoliciesResponse,
      ProjectPolicy
    ](
      "listProjectPolicies",
      api.listProjectPolicies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.projectPolicies().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.rekognition.model.ProjectPolicy.wrap(item))
      .provideEnvironment(r)
    def listProjectPoliciesPaginated(
        request: zio.aws.rekognition.model.ListProjectPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.ListProjectPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListProjectPoliciesRequest,
      ListProjectPoliciesResponse
    ]("listProjectPolicies", api.listProjectPolicies)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.ListProjectPoliciesResponse.wrap)
      .provideEnvironment(r)
    def compareFaces(
        request: zio.aws.rekognition.model.CompareFacesRequest
    ): IO[AwsError, zio.aws.rekognition.model.CompareFacesResponse.ReadOnly] =
      asyncRequestResponse[CompareFacesRequest, CompareFacesResponse](
        "compareFaces",
        api.compareFaces
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.CompareFacesResponse.wrap)
        .provideEnvironment(r)
    def getTextDetection(
        request: zio.aws.rekognition.model.GetTextDetectionRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly,
      zio.aws.rekognition.model.TextDetectionResult.ReadOnly
    ]] = asyncPaginatedRequest[
      GetTextDetectionRequest,
      GetTextDetectionResponse,
      TextDetectionResult
    ](
      "getTextDetection",
      api.getTextDetection,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.textDetections().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.rekognition.model.GetTextDetectionResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.rekognition.model.TextDetectionResult.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getTextDetectionPaginated(
        request: zio.aws.rekognition.model.GetTextDetectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly
    ] = asyncRequestResponse[GetTextDetectionRequest, GetTextDetectionResponse](
      "getTextDetection",
      api.getTextDetection
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.GetTextDetectionResponse.wrap)
      .provideEnvironment(r)
    def createStreamProcessor(
        request: zio.aws.rekognition.model.CreateStreamProcessorRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.CreateStreamProcessorResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateStreamProcessorRequest,
      CreateStreamProcessorResponse
    ]("createStreamProcessor", api.createStreamProcessor)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.CreateStreamProcessorResponse.wrap)
      .provideEnvironment(r)
    def createFaceLivenessSession(
        request: zio.aws.rekognition.model.CreateFaceLivenessSessionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateFaceLivenessSessionRequest,
      CreateFaceLivenessSessionResponse
    ]("createFaceLivenessSession", api.createFaceLivenessSession)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.wrap)
      .provideEnvironment(r)
    def describeStreamProcessor(
        request: zio.aws.rekognition.model.DescribeStreamProcessorRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DescribeStreamProcessorResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeStreamProcessorRequest,
      DescribeStreamProcessorResponse
    ]("describeStreamProcessor", api.describeStreamProcessor)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.DescribeStreamProcessorResponse.wrap)
      .provideEnvironment(r)
    def detectLabels(
        request: zio.aws.rekognition.model.DetectLabelsRequest
    ): IO[AwsError, zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly] =
      asyncRequestResponse[DetectLabelsRequest, DetectLabelsResponse](
        "detectLabels",
        api.detectLabels
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.DetectLabelsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.rekognition.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.rekognition.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: zio.aws.rekognition.model.CreateProjectRequest
    ): IO[AwsError, zio.aws.rekognition.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[CreateProjectRequest, CreateProjectResponse](
        "createProject",
        api.createProject
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def copyProjectVersion(
        request: zio.aws.rekognition.model.CopyProjectVersionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.CopyProjectVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CopyProjectVersionRequest,
      CopyProjectVersionResponse
    ]("copyProjectVersion", api.copyProjectVersion)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.CopyProjectVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteStreamProcessor(
        request: zio.aws.rekognition.model.DeleteStreamProcessorRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DeleteStreamProcessorResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteStreamProcessorRequest,
      DeleteStreamProcessorResponse
    ]("deleteStreamProcessor", api.deleteStreamProcessor)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.DeleteStreamProcessorResponse.wrap)
      .provideEnvironment(r)
    def getFaceLivenessSessionResults(
        request: zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetFaceLivenessSessionResultsRequest,
      GetFaceLivenessSessionResultsResponse
    ]("getFaceLivenessSessionResults", api.getFaceLivenessSessionResults)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.wrap)
      .provideEnvironment(r)
    def stopProjectVersion(
        request: zio.aws.rekognition.model.StopProjectVersionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StopProjectVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      StopProjectVersionRequest,
      StopProjectVersionResponse
    ]("stopProjectVersion", api.stopProjectVersion)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StopProjectVersionResponse.wrap)
      .provideEnvironment(r)
    def stopStreamProcessor(
        request: zio.aws.rekognition.model.StopStreamProcessorRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StopStreamProcessorResponse.ReadOnly
    ] = asyncRequestResponse[
      StopStreamProcessorRequest,
      StopStreamProcessorResponse
    ]("stopStreamProcessor", api.stopStreamProcessor)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StopStreamProcessorResponse.wrap)
      .provideEnvironment(r)
    def listFaces(
        request: zio.aws.rekognition.model.ListFacesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.rekognition.model.ListFacesResponse.ReadOnly,
      zio.aws.rekognition.model.Face.ReadOnly
    ]] = asyncPaginatedRequest[ListFacesRequest, ListFacesResponse, Face](
      "listFaces",
      api.listFaces,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.faces().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.rekognition.model.ListFacesResponse.wrap)
          .mapOutput(_.map(item => zio.aws.rekognition.model.Face.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listFacesPaginated(
        request: zio.aws.rekognition.model.ListFacesRequest
    ): IO[AwsError, zio.aws.rekognition.model.ListFacesResponse.ReadOnly] =
      asyncRequestResponse[ListFacesRequest, ListFacesResponse](
        "listFaces",
        api.listFaces
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.ListFacesResponse.wrap)
        .provideEnvironment(r)
    def putProjectPolicy(
        request: zio.aws.rekognition.model.PutProjectPolicyRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.PutProjectPolicyResponse.ReadOnly
    ] = asyncRequestResponse[PutProjectPolicyRequest, PutProjectPolicyResponse](
      "putProjectPolicy",
      api.putProjectPolicy
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.PutProjectPolicyResponse.wrap)
      .provideEnvironment(r)
    def startStreamProcessor(
        request: zio.aws.rekognition.model.StartStreamProcessorRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartStreamProcessorResponse.ReadOnly
    ] = asyncRequestResponse[
      StartStreamProcessorRequest,
      StartStreamProcessorResponse
    ]("startStreamProcessor", api.startStreamProcessor)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StartStreamProcessorResponse.wrap)
      .provideEnvironment(r)
    def startPersonTracking(
        request: zio.aws.rekognition.model.StartPersonTrackingRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartPersonTrackingResponse.ReadOnly
    ] = asyncRequestResponse[
      StartPersonTrackingRequest,
      StartPersonTrackingResponse
    ]("startPersonTracking", api.startPersonTracking)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StartPersonTrackingResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.rekognition.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listStreamProcessors(
        request: zio.aws.rekognition.model.ListStreamProcessorsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessor.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListStreamProcessorsRequest,
      ListStreamProcessorsResponse,
      StreamProcessor
    ](
      "listStreamProcessors",
      api.listStreamProcessors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.streamProcessors().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.rekognition.model.StreamProcessor.wrap(item))
      .provideEnvironment(r)
    def listStreamProcessorsPaginated(
        request: zio.aws.rekognition.model.ListStreamProcessorsRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.ListStreamProcessorsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListStreamProcessorsRequest,
      ListStreamProcessorsResponse
    ]("listStreamProcessors", api.listStreamProcessors)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.ListStreamProcessorsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.rekognition.model.TagResourceRequest
    ): IO[AwsError, zio.aws.rekognition.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listDatasetLabels(
        request: zio.aws.rekognition.model.ListDatasetLabelsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDatasetLabelsRequest,
      ListDatasetLabelsResponse,
      DatasetLabelDescription
    ](
      "listDatasetLabels",
      api.listDatasetLabels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.datasetLabelDescriptions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.rekognition.model.DatasetLabelDescription.wrap(item))
      .provideEnvironment(r)
    def listDatasetLabelsPaginated(
        request: zio.aws.rekognition.model.ListDatasetLabelsRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.ListDatasetLabelsResponse.ReadOnly
    ] =
      asyncRequestResponse[ListDatasetLabelsRequest, ListDatasetLabelsResponse](
        "listDatasetLabels",
        api.listDatasetLabels
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.ListDatasetLabelsResponse.wrap)
        .provideEnvironment(r)
    def detectProtectiveEquipment(
        request: zio.aws.rekognition.model.DetectProtectiveEquipmentRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.ReadOnly
    ] = asyncRequestResponse[
      DetectProtectiveEquipmentRequest,
      DetectProtectiveEquipmentResponse
    ]("detectProtectiveEquipment", api.detectProtectiveEquipment)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.wrap)
      .provideEnvironment(r)
    def deleteProjectPolicy(
        request: zio.aws.rekognition.model.DeleteProjectPolicyRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DeleteProjectPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteProjectPolicyRequest,
      DeleteProjectPolicyResponse
    ]("deleteProjectPolicy", api.deleteProjectPolicy)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.DeleteProjectPolicyResponse.wrap)
      .provideEnvironment(r)
    def startFaceDetection(
        request: zio.aws.rekognition.model.StartFaceDetectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartFaceDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartFaceDetectionRequest,
      StartFaceDetectionResponse
    ]("startFaceDetection", api.startFaceDetection)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StartFaceDetectionResponse.wrap)
      .provideEnvironment(r)
    def listCollections(
        request: zio.aws.rekognition.model.ListCollectionsRequest
    ): ZStream[Any, AwsError, CollectionId] = asyncJavaPaginatedRequest[
      ListCollectionsRequest,
      java.lang.String,
      ListCollectionsPublisher
    ]("listCollections", api.listCollectionsPaginator, _.collectionIds())(
      request.buildAwsValue()
    ).map(item => zio.aws.rekognition.model.primitives.CollectionId(item))
      .provideEnvironment(r)
    def listCollectionsPaginated(
        request: zio.aws.rekognition.model.ListCollectionsRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly
    ] = asyncRequestResponse[ListCollectionsRequest, ListCollectionsResponse](
      "listCollections",
      api.listCollections
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.ListCollectionsResponse.wrap)
      .provideEnvironment(r)
    def describeProjects(
        request: zio.aws.rekognition.model.DescribeProjectsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rekognition.model.ProjectDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeProjectsRequest,
      DescribeProjectsResponse,
      ProjectDescription
    ](
      "describeProjects",
      api.describeProjects,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.projectDescriptions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.rekognition.model.ProjectDescription.wrap(item))
      .provideEnvironment(r)
    def describeProjectsPaginated(
        request: zio.aws.rekognition.model.DescribeProjectsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[DescribeProjectsRequest, DescribeProjectsResponse](
        "describeProjects",
        api.describeProjects
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.DescribeProjectsResponse.wrap)
        .provideEnvironment(r)
    def getFaceSearch(
        request: zio.aws.rekognition.model.GetFaceSearchRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly,
      zio.aws.rekognition.model.PersonMatch.ReadOnly
    ]] = asyncPaginatedRequest[
      GetFaceSearchRequest,
      GetFaceSearchResponse,
      PersonMatch
    ](
      "getFaceSearch",
      api.getFaceSearch,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.persons().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.rekognition.model.GetFaceSearchResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.rekognition.model.PersonMatch.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getFaceSearchPaginated(
        request: zio.aws.rekognition.model.GetFaceSearchRequest
    ): IO[AwsError, zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly] =
      asyncRequestResponse[GetFaceSearchRequest, GetFaceSearchResponse](
        "getFaceSearch",
        api.getFaceSearch
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.GetFaceSearchResponse.wrap)
        .provideEnvironment(r)
    def detectModerationLabels(
        request: zio.aws.rekognition.model.DetectModerationLabelsRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DetectModerationLabelsResponse.ReadOnly
    ] = asyncRequestResponse[
      DetectModerationLabelsRequest,
      DetectModerationLabelsResponse
    ]("detectModerationLabels", api.detectModerationLabels)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.DetectModerationLabelsResponse.wrap)
      .provideEnvironment(r)
    def startSegmentDetection(
        request: zio.aws.rekognition.model.StartSegmentDetectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartSegmentDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartSegmentDetectionRequest,
      StartSegmentDetectionResponse
    ]("startSegmentDetection", api.startSegmentDetection)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.StartSegmentDetectionResponse.wrap)
      .provideEnvironment(r)
    def deleteDataset(
        request: zio.aws.rekognition.model.DeleteDatasetRequest
    ): IO[AwsError, zio.aws.rekognition.model.DeleteDatasetResponse.ReadOnly] =
      asyncRequestResponse[DeleteDatasetRequest, DeleteDatasetResponse](
        "deleteDataset",
        api.deleteDataset
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.DeleteDatasetResponse.wrap)
        .provideEnvironment(r)
    def startContentModeration(
        request: zio.aws.rekognition.model.StartContentModerationRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartContentModerationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartContentModerationRequest,
      StartContentModerationResponse
    ]("startContentModeration", api.startContentModeration)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.StartContentModerationResponse.wrap)
      .provideEnvironment(r)
    def getCelebrityInfo(
        request: zio.aws.rekognition.model.GetCelebrityInfoRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetCelebrityInfoResponse.ReadOnly
    ] = asyncRequestResponse[GetCelebrityInfoRequest, GetCelebrityInfoResponse](
      "getCelebrityInfo",
      api.getCelebrityInfo
    )(request.buildAwsValue())
      .map(zio.aws.rekognition.model.GetCelebrityInfoResponse.wrap)
      .provideEnvironment(r)
    def deleteProject(
        request: zio.aws.rekognition.model.DeleteProjectRequest
    ): IO[AwsError, zio.aws.rekognition.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[DeleteProjectRequest, DeleteProjectResponse](
        "deleteProject",
        api.deleteProject
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def startLabelDetection(
        request: zio.aws.rekognition.model.StartLabelDetectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.StartLabelDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartLabelDetectionRequest,
      StartLabelDetectionResponse
    ]("startLabelDetection", api.startLabelDetection)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.StartLabelDetectionResponse.wrap)
      .provideEnvironment(r)
    def recognizeCelebrities(
        request: zio.aws.rekognition.model.RecognizeCelebritiesRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly
    ] = asyncRequestResponse[
      RecognizeCelebritiesRequest,
      RecognizeCelebritiesResponse
    ]("recognizeCelebrities", api.recognizeCelebrities)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.RecognizeCelebritiesResponse.wrap)
      .provideEnvironment(r)
    def getContentModeration(
        request: zio.aws.rekognition.model.GetContentModerationRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly,
      zio.aws.rekognition.model.ContentModerationDetection.ReadOnly
    ]] = asyncPaginatedRequest[
      GetContentModerationRequest,
      GetContentModerationResponse,
      ContentModerationDetection
    ](
      "getContentModeration",
      api.getContentModeration,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.moderationLabels().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.rekognition.model.GetContentModerationResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.rekognition.model.ContentModerationDetection.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getContentModerationPaginated(
        request: zio.aws.rekognition.model.GetContentModerationRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetContentModerationRequest,
      GetContentModerationResponse
    ]("getContentModeration", api.getContentModeration)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.GetContentModerationResponse.wrap)
      .provideEnvironment(r)
    def getLabelDetection(
        request: zio.aws.rekognition.model.GetLabelDetectionRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly,
      zio.aws.rekognition.model.LabelDetection.ReadOnly
    ]] = asyncPaginatedRequest[
      GetLabelDetectionRequest,
      GetLabelDetectionResponse,
      LabelDetection
    ](
      "getLabelDetection",
      api.getLabelDetection,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.labels().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.rekognition.model.GetLabelDetectionResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.rekognition.model.LabelDetection.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getLabelDetectionPaginated(
        request: zio.aws.rekognition.model.GetLabelDetectionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly
    ] =
      asyncRequestResponse[GetLabelDetectionRequest, GetLabelDetectionResponse](
        "getLabelDetection",
        api.getLabelDetection
      )(request.buildAwsValue())
        .map(zio.aws.rekognition.model.GetLabelDetectionResponse.wrap)
        .provideEnvironment(r)
    def deleteProjectVersion(
        request: zio.aws.rekognition.model.DeleteProjectVersionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.DeleteProjectVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteProjectVersionRequest,
      DeleteProjectVersionResponse
    ]("deleteProjectVersion", api.deleteProjectVersion)(request.buildAwsValue())
      .map(zio.aws.rekognition.model.DeleteProjectVersionResponse.wrap)
      .provideEnvironment(r)
    def getCelebrityRecognition(
        request: zio.aws.rekognition.model.GetCelebrityRecognitionRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly,
      zio.aws.rekognition.model.CelebrityRecognition.ReadOnly
    ]] = asyncPaginatedRequest[
      GetCelebrityRecognitionRequest,
      GetCelebrityRecognitionResponse,
      CelebrityRecognition
    ](
      "getCelebrityRecognition",
      api.getCelebrityRecognition,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.celebrities().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.rekognition.model.GetCelebrityRecognitionResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.rekognition.model.CelebrityRecognition.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getCelebrityRecognitionPaginated(
        request: zio.aws.rekognition.model.GetCelebrityRecognitionRequest
    ): IO[
      AwsError,
      zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCelebrityRecognitionRequest,
      GetCelebrityRecognitionResponse
    ]("getCelebrityRecognition", api.getCelebrityRecognition)(
      request.buildAwsValue()
    ).map(zio.aws.rekognition.model.GetCelebrityRecognitionResponse.wrap)
      .provideEnvironment(r)
  }
  def listDatasetEntries(
      request: zio.aws.rekognition.model.ListDatasetEntriesRequest
  ): ZStream[zio.aws.rekognition.Rekognition, AwsError, DatasetEntry] =
    ZStream.serviceWithStream(_.listDatasetEntries(request))
  def listDatasetEntriesPaginated(
      request: zio.aws.rekognition.model.ListDatasetEntriesRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ListDatasetEntriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetEntriesPaginated(request))
  def createDataset(
      request: zio.aws.rekognition.model.CreateDatasetRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def getSegmentDetection(
      request: zio.aws.rekognition.model.GetSegmentDetectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetSegmentDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSegmentDetection(request))
  def indexFaces(request: zio.aws.rekognition.model.IndexFacesRequest): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.IndexFacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.indexFaces(request))
  def updateStreamProcessor(
      request: zio.aws.rekognition.model.UpdateStreamProcessorRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.UpdateStreamProcessorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStreamProcessor(request))
  def startCelebrityRecognition(
      request: zio.aws.rekognition.model.StartCelebrityRecognitionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartCelebrityRecognitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startCelebrityRecognition(request))
  def distributeDatasetEntries(
      request: zio.aws.rekognition.model.DistributeDatasetEntriesRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DistributeDatasetEntriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.distributeDatasetEntries(request))
  def detectText(request: zio.aws.rekognition.model.DetectTextRequest): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DetectTextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectText(request))
  def detectCustomLabels(
      request: zio.aws.rekognition.model.DetectCustomLabelsRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DetectCustomLabelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectCustomLabels(request))
  def createProjectVersion(
      request: zio.aws.rekognition.model.CreateProjectVersionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.CreateProjectVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProjectVersion(request))
  def startTextDetection(
      request: zio.aws.rekognition.model.StartTextDetectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartTextDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTextDetection(request))
  def createCollection(
      request: zio.aws.rekognition.model.CreateCollectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.CreateCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCollection(request))
  def searchFacesByImage(
      request: zio.aws.rekognition.model.SearchFacesByImageRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchFacesByImage(request))
  def searchFaces(request: zio.aws.rekognition.model.SearchFacesRequest): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.SearchFacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchFaces(request))
  def describeProjectVersions(
      request: zio.aws.rekognition.model.DescribeProjectVersionsRequest
  ): ZStream[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeProjectVersions(request))
  def describeProjectVersionsPaginated(
      request: zio.aws.rekognition.model.DescribeProjectVersionsRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DescribeProjectVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProjectVersionsPaginated(request))
  def startProjectVersion(
      request: zio.aws.rekognition.model.StartProjectVersionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartProjectVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startProjectVersion(request))
  def deleteCollection(
      request: zio.aws.rekognition.model.DeleteCollectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DeleteCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCollection(request))
  def updateDatasetEntries(
      request: zio.aws.rekognition.model.UpdateDatasetEntriesRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.UpdateDatasetEntriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDatasetEntries(request))
  def describeCollection(
      request: zio.aws.rekognition.model.DescribeCollectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DescribeCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCollection(request))
  def getPersonTracking(
      request: zio.aws.rekognition.model.GetPersonTrackingRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly,
    zio.aws.rekognition.model.PersonDetection.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getPersonTracking(request))
  def getPersonTrackingPaginated(
      request: zio.aws.rekognition.model.GetPersonTrackingRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPersonTrackingPaginated(request))
  def getFaceDetection(
      request: zio.aws.rekognition.model.GetFaceDetectionRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly,
    zio.aws.rekognition.model.FaceDetection.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getFaceDetection(request))
  def getFaceDetectionPaginated(
      request: zio.aws.rekognition.model.GetFaceDetectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFaceDetectionPaginated(request))
  def describeDataset(
      request: zio.aws.rekognition.model.DescribeDatasetRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def detectFaces(request: zio.aws.rekognition.model.DetectFacesRequest): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DetectFacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectFaces(request))
  def startFaceSearch(
      request: zio.aws.rekognition.model.StartFaceSearchRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartFaceSearchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startFaceSearch(request))
  def deleteFaces(request: zio.aws.rekognition.model.DeleteFacesRequest): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DeleteFacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFaces(request))
  def listProjectPolicies(
      request: zio.aws.rekognition.model.ListProjectPoliciesRequest
  ): ZStream[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ProjectPolicy.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjectPolicies(request))
  def listProjectPoliciesPaginated(
      request: zio.aws.rekognition.model.ListProjectPoliciesRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ListProjectPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectPoliciesPaginated(request))
  def compareFaces(request: zio.aws.rekognition.model.CompareFacesRequest): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.CompareFacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.compareFaces(request))
  def getTextDetection(
      request: zio.aws.rekognition.model.GetTextDetectionRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly,
    zio.aws.rekognition.model.TextDetectionResult.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getTextDetection(request))
  def getTextDetectionPaginated(
      request: zio.aws.rekognition.model.GetTextDetectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetTextDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTextDetectionPaginated(request))
  def createStreamProcessor(
      request: zio.aws.rekognition.model.CreateStreamProcessorRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.CreateStreamProcessorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStreamProcessor(request))
  def createFaceLivenessSession(
      request: zio.aws.rekognition.model.CreateFaceLivenessSessionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.CreateFaceLivenessSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFaceLivenessSession(request))
  def describeStreamProcessor(
      request: zio.aws.rekognition.model.DescribeStreamProcessorRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DescribeStreamProcessorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStreamProcessor(request))
  def detectLabels(request: zio.aws.rekognition.model.DetectLabelsRequest): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectLabels(request))
  def untagResource(
      request: zio.aws.rekognition.model.UntagResourceRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createProject(
      request: zio.aws.rekognition.model.CreateProjectRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def copyProjectVersion(
      request: zio.aws.rekognition.model.CopyProjectVersionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.CopyProjectVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyProjectVersion(request))
  def deleteStreamProcessor(
      request: zio.aws.rekognition.model.DeleteStreamProcessorRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DeleteStreamProcessorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStreamProcessor(request))
  def getFaceLivenessSessionResults(
      request: zio.aws.rekognition.model.GetFaceLivenessSessionResultsRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetFaceLivenessSessionResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFaceLivenessSessionResults(request))
  def stopProjectVersion(
      request: zio.aws.rekognition.model.StopProjectVersionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StopProjectVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopProjectVersion(request))
  def stopStreamProcessor(
      request: zio.aws.rekognition.model.StopStreamProcessorRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StopStreamProcessorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopStreamProcessor(request))
  def listFaces(
      request: zio.aws.rekognition.model.ListFacesRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.ListFacesResponse.ReadOnly,
    zio.aws.rekognition.model.Face.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listFaces(request))
  def listFacesPaginated(
      request: zio.aws.rekognition.model.ListFacesRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ListFacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFacesPaginated(request))
  def putProjectPolicy(
      request: zio.aws.rekognition.model.PutProjectPolicyRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.PutProjectPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putProjectPolicy(request))
  def startStreamProcessor(
      request: zio.aws.rekognition.model.StartStreamProcessorRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartStreamProcessorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startStreamProcessor(request))
  def startPersonTracking(
      request: zio.aws.rekognition.model.StartPersonTrackingRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartPersonTrackingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startPersonTracking(request))
  def listTagsForResource(
      request: zio.aws.rekognition.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listStreamProcessors(
      request: zio.aws.rekognition.model.ListStreamProcessorsRequest
  ): ZStream[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StreamProcessor.ReadOnly
  ] = ZStream.serviceWithStream(_.listStreamProcessors(request))
  def listStreamProcessorsPaginated(
      request: zio.aws.rekognition.model.ListStreamProcessorsRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ListStreamProcessorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreamProcessorsPaginated(request))
  def tagResource(request: zio.aws.rekognition.model.TagResourceRequest): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listDatasetLabels(
      request: zio.aws.rekognition.model.ListDatasetLabelsRequest
  ): ZStream[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DatasetLabelDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasetLabels(request))
  def listDatasetLabelsPaginated(
      request: zio.aws.rekognition.model.ListDatasetLabelsRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ListDatasetLabelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetLabelsPaginated(request))
  def detectProtectiveEquipment(
      request: zio.aws.rekognition.model.DetectProtectiveEquipmentRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectProtectiveEquipment(request))
  def deleteProjectPolicy(
      request: zio.aws.rekognition.model.DeleteProjectPolicyRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DeleteProjectPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProjectPolicy(request))
  def startFaceDetection(
      request: zio.aws.rekognition.model.StartFaceDetectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartFaceDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startFaceDetection(request))
  def listCollections(
      request: zio.aws.rekognition.model.ListCollectionsRequest
  ): ZStream[zio.aws.rekognition.Rekognition, AwsError, CollectionId] =
    ZStream.serviceWithStream(_.listCollections(request))
  def listCollectionsPaginated(
      request: zio.aws.rekognition.model.ListCollectionsRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCollectionsPaginated(request))
  def describeProjects(
      request: zio.aws.rekognition.model.DescribeProjectsRequest
  ): ZStream[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.ProjectDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeProjects(request))
  def describeProjectsPaginated(
      request: zio.aws.rekognition.model.DescribeProjectsRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeProjectsPaginated(request))
  def getFaceSearch(
      request: zio.aws.rekognition.model.GetFaceSearchRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly,
    zio.aws.rekognition.model.PersonMatch.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getFaceSearch(request))
  def getFaceSearchPaginated(
      request: zio.aws.rekognition.model.GetFaceSearchRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetFaceSearchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFaceSearchPaginated(request))
  def detectModerationLabels(
      request: zio.aws.rekognition.model.DetectModerationLabelsRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DetectModerationLabelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectModerationLabels(request))
  def startSegmentDetection(
      request: zio.aws.rekognition.model.StartSegmentDetectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartSegmentDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSegmentDetection(request))
  def deleteDataset(
      request: zio.aws.rekognition.model.DeleteDatasetRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DeleteDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataset(request))
  def startContentModeration(
      request: zio.aws.rekognition.model.StartContentModerationRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartContentModerationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startContentModeration(request))
  def getCelebrityInfo(
      request: zio.aws.rekognition.model.GetCelebrityInfoRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetCelebrityInfoResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCelebrityInfo(request))
  def deleteProject(
      request: zio.aws.rekognition.model.DeleteProjectRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def startLabelDetection(
      request: zio.aws.rekognition.model.StartLabelDetectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.StartLabelDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startLabelDetection(request))
  def recognizeCelebrities(
      request: zio.aws.rekognition.model.RecognizeCelebritiesRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.recognizeCelebrities(request))
  def getContentModeration(
      request: zio.aws.rekognition.model.GetContentModerationRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly,
    zio.aws.rekognition.model.ContentModerationDetection.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getContentModeration(request))
  def getContentModerationPaginated(
      request: zio.aws.rekognition.model.GetContentModerationRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContentModerationPaginated(request))
  def getLabelDetection(
      request: zio.aws.rekognition.model.GetLabelDetectionRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly,
    zio.aws.rekognition.model.LabelDetection.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getLabelDetection(request))
  def getLabelDetectionPaginated(
      request: zio.aws.rekognition.model.GetLabelDetectionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetLabelDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLabelDetectionPaginated(request))
  def deleteProjectVersion(
      request: zio.aws.rekognition.model.DeleteProjectVersionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.DeleteProjectVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProjectVersion(request))
  def getCelebrityRecognition(
      request: zio.aws.rekognition.model.GetCelebrityRecognitionRequest
  ): ZIO[zio.aws.rekognition.Rekognition, AwsError, StreamingOutputResult[
    Any,
    zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly,
    zio.aws.rekognition.model.CelebrityRecognition.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getCelebrityRecognition(request))
  def getCelebrityRecognitionPaginated(
      request: zio.aws.rekognition.model.GetCelebrityRecognitionRequest
  ): ZIO[
    zio.aws.rekognition.Rekognition,
    AwsError,
    zio.aws.rekognition.model.GetCelebrityRecognitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCelebrityRecognitionPaginated(request))
}
