package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait UserStatus {
  def unwrap: software.amazon.awssdk.services.rekognition.model.UserStatus
}
object UserStatus {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.UserStatus
  ): zio.aws.rekognition.model.UserStatus = value match {
    case software.amazon.awssdk.services.rekognition.model.UserStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.UserStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.rekognition.model.UserStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.rekognition.model.UserStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.rekognition.model.UserStatus.CREATED =>
      val r = CREATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.rekognition.model.UserStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UserStatus =
      software.amazon.awssdk.services.rekognition.model.UserStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.rekognition.model.UserStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UserStatus =
      software.amazon.awssdk.services.rekognition.model.UserStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.rekognition.model.UserStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UserStatus =
      software.amazon.awssdk.services.rekognition.model.UserStatus.UPDATING
  }
  case object CREATING extends zio.aws.rekognition.model.UserStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UserStatus =
      software.amazon.awssdk.services.rekognition.model.UserStatus.CREATING
  }
  case object CREATED extends zio.aws.rekognition.model.UserStatus {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UserStatus =
      software.amazon.awssdk.services.rekognition.model.UserStatus.CREATED
  }
}
