package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserMatch(
    similarity: Optional[Percent] = Optional.Absent,
    user: Optional[zio.aws.rekognition.model.MatchedUser] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.UserMatch = {
    import UserMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.UserMatch
      .builder()
      .optionallyWith(
        similarity.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.similarity)
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.UserMatch.ReadOnly =
    zio.aws.rekognition.model.UserMatch.wrap(buildAwsValue())
}
object UserMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.UserMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.UserMatch =
      zio.aws.rekognition.model.UserMatch(
        similarity.map(value => value),
        user.map(value => value.asEditable)
      )
    def similarity: Optional[Percent]
    def user: Optional[zio.aws.rekognition.model.MatchedUser.ReadOnly]
    def getSimilarity: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("similarity", similarity)
    def getUser
        : ZIO[Any, AwsError, zio.aws.rekognition.model.MatchedUser.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.UserMatch
  ) extends zio.aws.rekognition.model.UserMatch.ReadOnly {
    override val similarity: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.similarity())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val user
        : Optional[zio.aws.rekognition.model.MatchedUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.rekognition.model.MatchedUser.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.UserMatch
  ): zio.aws.rekognition.model.UserMatch.ReadOnly = new Wrapper(impl)
}
