package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.UserId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class User(
    userId: Optional[UserId] = Optional.Absent,
    userStatus: Optional[zio.aws.rekognition.model.UserStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.User
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(userStatus.map(value => value.unwrap))(_.userStatus)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.User.ReadOnly =
    zio.aws.rekognition.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.User = zio.aws.rekognition.model
      .User(userId.map(value => value), userStatus.map(value => value))
    def userId: Optional[UserId]
    def userStatus: Optional[zio.aws.rekognition.model.UserStatus]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.UserStatus] =
      AwsError.unwrapOptionField("userStatus", userStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.User
  ) extends zio.aws.rekognition.model.User.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.rekognition.model.primitives.UserId(value))
    override val userStatus: Optional[zio.aws.rekognition.model.UserStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userStatus())
        .map(value => zio.aws.rekognition.model.UserStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.User
  ): zio.aws.rekognition.model.User.ReadOnly = new Wrapper(impl)
}
