package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStreamProcessorRequest(
    name: StreamProcessorName,
    settingsForUpdate: Optional[
      zio.aws.rekognition.model.StreamProcessorSettingsForUpdate
    ] = Optional.Absent,
    regionsOfInterestForUpdate: Optional[
      Iterable[zio.aws.rekognition.model.RegionOfInterest]
    ] = Optional.Absent,
    dataSharingPreferenceForUpdate: Optional[
      zio.aws.rekognition.model.StreamProcessorDataSharingPreference
    ] = Optional.Absent,
    parametersToDelete: Optional[
      Iterable[zio.aws.rekognition.model.StreamProcessorParameterToDelete]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorRequest = {
    import UpdateStreamProcessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorRequest
      .builder()
      .name(StreamProcessorName.unwrap(name): java.lang.String)
      .optionallyWith(settingsForUpdate.map(value => value.buildAwsValue()))(
        _.settingsForUpdate
      )
      .optionallyWith(
        regionsOfInterestForUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regionsOfInterestForUpdate)
      .optionallyWith(
        dataSharingPreferenceForUpdate.map(value => value.buildAwsValue())
      )(_.dataSharingPreferenceForUpdate)
      .optionallyWith(
        parametersToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.parametersToDeleteWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.UpdateStreamProcessorRequest.ReadOnly =
    zio.aws.rekognition.model.UpdateStreamProcessorRequest.wrap(buildAwsValue())
}
object UpdateStreamProcessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.UpdateStreamProcessorRequest =
      zio.aws.rekognition.model.UpdateStreamProcessorRequest(
        name,
        settingsForUpdate.map(value => value.asEditable),
        regionsOfInterestForUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSharingPreferenceForUpdate.map(value => value.asEditable),
        parametersToDelete.map(value => value)
      )
    def name: StreamProcessorName
    def settingsForUpdate: Optional[
      zio.aws.rekognition.model.StreamProcessorSettingsForUpdate.ReadOnly
    ]
    def regionsOfInterestForUpdate
        : Optional[List[zio.aws.rekognition.model.RegionOfInterest.ReadOnly]]
    def dataSharingPreferenceForUpdate: Optional[
      zio.aws.rekognition.model.StreamProcessorDataSharingPreference.ReadOnly
    ]
    def parametersToDelete: Optional[
      List[zio.aws.rekognition.model.StreamProcessorParameterToDelete]
    ]
    def getName: ZIO[Any, Nothing, StreamProcessorName] = ZIO.succeed(name)
    def getSettingsForUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessorSettingsForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("settingsForUpdate", settingsForUpdate)
    def getRegionsOfInterestForUpdate: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.RegionOfInterest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "regionsOfInterestForUpdate",
      regionsOfInterestForUpdate
    )
    def getDataSharingPreferenceForUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessorDataSharingPreference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataSharingPreferenceForUpdate",
      dataSharingPreferenceForUpdate
    )
    def getParametersToDelete: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.StreamProcessorParameterToDelete
    ]] = AwsError.unwrapOptionField("parametersToDelete", parametersToDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorRequest
  ) extends zio.aws.rekognition.model.UpdateStreamProcessorRequest.ReadOnly {
    override val name: StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName(impl.name())
    override val settingsForUpdate: Optional[
      zio.aws.rekognition.model.StreamProcessorSettingsForUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.settingsForUpdate())
      .map(value =>
        zio.aws.rekognition.model.StreamProcessorSettingsForUpdate.wrap(value)
      )
    override val regionsOfInterestForUpdate
        : Optional[List[zio.aws.rekognition.model.RegionOfInterest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionsOfInterestForUpdate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.RegionOfInterest.wrap(item)
          }.toList
        )
    override val dataSharingPreferenceForUpdate: Optional[
      zio.aws.rekognition.model.StreamProcessorDataSharingPreference.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSharingPreferenceForUpdate())
      .map(value =>
        zio.aws.rekognition.model.StreamProcessorDataSharingPreference
          .wrap(value)
      )
    override val parametersToDelete: Optional[
      List[zio.aws.rekognition.model.StreamProcessorParameterToDelete]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parametersToDelete())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.StreamProcessorParameterToDelete.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorRequest
  ): zio.aws.rekognition.model.UpdateStreamProcessorRequest.ReadOnly =
    new Wrapper(impl)
}
