package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait UnsuccessfulFaceDisassociationReason {
  def unwrap: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason
}
object UnsuccessfulFaceDisassociationReason {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason
  ): zio.aws.rekognition.model.UnsuccessfulFaceDisassociationReason =
    value match {
      case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason.FACE_NOT_FOUND =>
        val r = FACE_NOT_FOUND
        r
      case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason.ASSOCIATED_TO_A_DIFFERENT_USER =>
        val r = ASSOCIATED_TO_A_DIFFERENT_USER
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.UnsuccessfulFaceDisassociationReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason.UNKNOWN_TO_SDK_VERSION
  }
  case object FACE_NOT_FOUND
      extends zio.aws.rekognition.model.UnsuccessfulFaceDisassociationReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason.FACE_NOT_FOUND
  }
  case object ASSOCIATED_TO_A_DIFFERENT_USER
      extends zio.aws.rekognition.model.UnsuccessfulFaceDisassociationReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationReason.ASSOCIATED_TO_A_DIFFERENT_USER
  }
}
