package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait UnsuccessfulFaceDeletionReason {
  def unwrap: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason
}
object UnsuccessfulFaceDeletionReason {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason
  ): zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason = value match {
    case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason.ASSOCIATED_TO_AN_EXISTING_USER =>
      val r = ASSOCIATED_TO_AN_EXISTING_USER
      r
    case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason.FACE_NOT_FOUND =>
      val r = FACE_NOT_FOUND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSOCIATED_TO_AN_EXISTING_USER
      extends zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason.ASSOCIATED_TO_AN_EXISTING_USER
  }
  case object FACE_NOT_FOUND
      extends zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletionReason.FACE_NOT_FOUND
  }
}
