package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{UserId, FaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnsuccessfulFaceDeletion(
    faceId: Optional[FaceId] = Optional.Absent,
    userId: Optional[UserId] = Optional.Absent,
    reasons: Optional[
      Iterable[zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion = {
    import UnsuccessfulFaceDeletion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion
      .builder()
      .optionallyWith(
        faceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.faceId)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        reasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reasonsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.UnsuccessfulFaceDeletion.ReadOnly =
    zio.aws.rekognition.model.UnsuccessfulFaceDeletion.wrap(buildAwsValue())
}
object UnsuccessfulFaceDeletion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.UnsuccessfulFaceDeletion =
      zio.aws.rekognition.model.UnsuccessfulFaceDeletion(
        faceId.map(value => value),
        userId.map(value => value),
        reasons.map(value => value)
      )
    def faceId: Optional[FaceId]
    def userId: Optional[UserId]
    def reasons: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason]
    ]
    def getFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("faceId", faceId)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getReasons: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason
    ]] = AwsError.unwrapOptionField("reasons", reasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion
  ) extends zio.aws.rekognition.model.UnsuccessfulFaceDeletion.ReadOnly {
    override val faceId: Optional[FaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.faceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.rekognition.model.primitives.UserId(value))
    override val reasons: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.UnsuccessfulFaceDeletionReason.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion
  ): zio.aws.rekognition.model.UnsuccessfulFaceDeletion.ReadOnly = new Wrapper(
    impl
  )
}
