package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait UnsuccessfulFaceAssociationReason {
  def unwrap: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason
}
object UnsuccessfulFaceAssociationReason {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason
  ): zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason = value match {
    case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason.FACE_NOT_FOUND =>
      val r = FACE_NOT_FOUND
      r
    case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason.ASSOCIATED_TO_A_DIFFERENT_USER =>
      val r = ASSOCIATED_TO_A_DIFFERENT_USER
      r
    case software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason.LOW_MATCH_CONFIDENCE =>
      val r = LOW_MATCH_CONFIDENCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason.UNKNOWN_TO_SDK_VERSION
  }
  case object FACE_NOT_FOUND
      extends zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason.FACE_NOT_FOUND
  }
  case object ASSOCIATED_TO_A_DIFFERENT_USER
      extends zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason.ASSOCIATED_TO_A_DIFFERENT_USER
  }
  case object LOW_MATCH_CONFIDENCE
      extends zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason =
      software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociationReason.LOW_MATCH_CONFIDENCE
  }
}
