package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, UserId, FaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnsuccessfulFaceAssociation(
    faceId: Optional[FaceId] = Optional.Absent,
    userId: Optional[UserId] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    reasons: Optional[
      Iterable[zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation = {
    import UnsuccessfulFaceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation
      .builder()
      .optionallyWith(
        faceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.faceId)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(
        reasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reasonsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.UnsuccessfulFaceAssociation.ReadOnly =
    zio.aws.rekognition.model.UnsuccessfulFaceAssociation.wrap(buildAwsValue())
}
object UnsuccessfulFaceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.UnsuccessfulFaceAssociation =
      zio.aws.rekognition.model.UnsuccessfulFaceAssociation(
        faceId.map(value => value),
        userId.map(value => value),
        confidence.map(value => value),
        reasons.map(value => value)
      )
    def faceId: Optional[FaceId]
    def userId: Optional[UserId]
    def confidence: Optional[Percent]
    def reasons: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason]
    ]
    def getFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("faceId", faceId)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getReasons: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason
    ]] = AwsError.unwrapOptionField("reasons", reasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation
  ) extends zio.aws.rekognition.model.UnsuccessfulFaceAssociation.ReadOnly {
    override val faceId: Optional[FaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.faceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.rekognition.model.primitives.UserId(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val reasons: Optional[
      List[zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.UnsuccessfulFaceAssociationReason.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation
  ): zio.aws.rekognition.model.UnsuccessfulFaceAssociation.ReadOnly =
    new Wrapper(impl)
}
