package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait UnsearchedFaceReason {
  def unwrap
      : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason
}
object UnsearchedFaceReason {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason
  ): zio.aws.rekognition.model.UnsearchedFaceReason = value match {
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.FACE_NOT_LARGEST =>
      val r = FACE_NOT_LARGEST
      r
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.EXCEEDS_MAX_FACES =>
      val r = EXCEEDS_MAX_FACES
      r
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.EXTREME_POSE =>
      val r = EXTREME_POSE
      r
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.LOW_BRIGHTNESS =>
      val r = LOW_BRIGHTNESS
      r
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.LOW_SHARPNESS =>
      val r = LOW_SHARPNESS
      r
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.LOW_CONFIDENCE =>
      val r = LOW_CONFIDENCE
      r
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.SMALL_BOUNDING_BOX =>
      val r = SMALL_BOUNDING_BOX
      r
    case software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.LOW_FACE_QUALITY =>
      val r = LOW_FACE_QUALITY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.UNKNOWN_TO_SDK_VERSION
  }
  case object FACE_NOT_LARGEST
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.FACE_NOT_LARGEST
  }
  case object EXCEEDS_MAX_FACES
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.EXCEEDS_MAX_FACES
  }
  case object EXTREME_POSE
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.EXTREME_POSE
  }
  case object LOW_BRIGHTNESS
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.LOW_BRIGHTNESS
  }
  case object LOW_SHARPNESS
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.LOW_SHARPNESS
  }
  case object LOW_CONFIDENCE
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.LOW_CONFIDENCE
  }
  case object SMALL_BOUNDING_BOX
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.SMALL_BOUNDING_BOX
  }
  case object LOW_FACE_QUALITY
      extends zio.aws.rekognition.model.UnsearchedFaceReason {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason =
      software.amazon.awssdk.services.rekognition.model.UnsearchedFaceReason.LOW_FACE_QUALITY
  }
}
