package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnsearchedFace(
    faceDetails: Optional[zio.aws.rekognition.model.FaceDetail] =
      Optional.Absent,
    reasons: Optional[
      Iterable[zio.aws.rekognition.model.UnsearchedFaceReason]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.UnsearchedFace = {
    import UnsearchedFace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.UnsearchedFace
      .builder()
      .optionallyWith(faceDetails.map(value => value.buildAwsValue()))(
        _.faceDetails
      )
      .optionallyWith(
        reasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reasonsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.UnsearchedFace.ReadOnly =
    zio.aws.rekognition.model.UnsearchedFace.wrap(buildAwsValue())
}
object UnsearchedFace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.UnsearchedFace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.UnsearchedFace =
      zio.aws.rekognition.model.UnsearchedFace(
        faceDetails.map(value => value.asEditable),
        reasons.map(value => value)
      )
    def faceDetails: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly]
    def reasons: Optional[List[zio.aws.rekognition.model.UnsearchedFaceReason]]
    def getFaceDetails
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      AwsError.unwrapOptionField("faceDetails", faceDetails)
    def getReasons: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UnsearchedFaceReason
    ]] = AwsError.unwrapOptionField("reasons", reasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.UnsearchedFace
  ) extends zio.aws.rekognition.model.UnsearchedFace.ReadOnly {
    override val faceDetails
        : Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceDetails())
        .map(value => zio.aws.rekognition.model.FaceDetail.wrap(value))
    override val reasons
        : Optional[List[zio.aws.rekognition.model.UnsearchedFaceReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.UnsearchedFaceReason.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.UnsearchedFace
  ): zio.aws.rekognition.model.UnsearchedFace.ReadOnly = new Wrapper(impl)
}
