package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.MaxDurationInSecondsULong
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamProcessingStopSelector(
    maxDurationInSeconds: Optional[MaxDurationInSecondsULong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessingStopSelector = {
    import StreamProcessingStopSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessingStopSelector
      .builder()
      .optionallyWith(
        maxDurationInSeconds.map(value =>
          MaxDurationInSecondsULong.unwrap(value): java.lang.Long
        )
      )(_.maxDurationInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StreamProcessingStopSelector.ReadOnly =
    zio.aws.rekognition.model.StreamProcessingStopSelector.wrap(buildAwsValue())
}
object StreamProcessingStopSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessingStopSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessingStopSelector =
      zio.aws.rekognition.model
        .StreamProcessingStopSelector(maxDurationInSeconds.map(value => value))
    def maxDurationInSeconds: Optional[MaxDurationInSecondsULong]
    def getMaxDurationInSeconds: ZIO[Any, AwsError, MaxDurationInSecondsULong] =
      AwsError.unwrapOptionField("maxDurationInSeconds", maxDurationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessingStopSelector
  ) extends zio.aws.rekognition.model.StreamProcessingStopSelector.ReadOnly {
    override val maxDurationInSeconds: Optional[MaxDurationInSecondsULong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDurationInSeconds())
        .map(value =>
          zio.aws.rekognition.model.primitives.MaxDurationInSecondsULong(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessingStopSelector
  ): zio.aws.rekognition.model.StreamProcessingStopSelector.ReadOnly =
    new Wrapper(impl)
}
