package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.UserId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchedUser(userId: Optional[UserId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchedUser = {
    import SearchedUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchedUser
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchedUser.ReadOnly =
    zio.aws.rekognition.model.SearchedUser.wrap(buildAwsValue())
}
object SearchedUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchedUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchedUser =
      zio.aws.rekognition.model.SearchedUser(userId.map(value => value))
    def userId: Optional[UserId]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchedUser
  ) extends zio.aws.rekognition.model.SearchedUser.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.rekognition.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchedUser
  ): zio.aws.rekognition.model.SearchedUser.ReadOnly = new Wrapper(impl)
}
