package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchedFaceDetails(
    faceDetail: Optional[zio.aws.rekognition.model.FaceDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchedFaceDetails = {
    import SearchedFaceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchedFaceDetails
      .builder()
      .optionallyWith(faceDetail.map(value => value.buildAwsValue()))(
        _.faceDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchedFaceDetails.ReadOnly =
    zio.aws.rekognition.model.SearchedFaceDetails.wrap(buildAwsValue())
}
object SearchedFaceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchedFaceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchedFaceDetails =
      zio.aws.rekognition.model
        .SearchedFaceDetails(faceDetail.map(value => value.asEditable))
    def faceDetail: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly]
    def getFaceDetail
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      AwsError.unwrapOptionField("faceDetail", faceDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchedFaceDetails
  ) extends zio.aws.rekognition.model.SearchedFaceDetails.ReadOnly {
    override val faceDetail
        : Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceDetail())
        .map(value => zio.aws.rekognition.model.FaceDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchedFaceDetails
  ): zio.aws.rekognition.model.SearchedFaceDetails.ReadOnly = new Wrapper(impl)
}
