package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.FaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchedFace(faceId: Optional[FaceId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchedFace = {
    import SearchedFace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchedFace
      .builder()
      .optionallyWith(
        faceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.faceId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchedFace.ReadOnly =
    zio.aws.rekognition.model.SearchedFace.wrap(buildAwsValue())
}
object SearchedFace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchedFace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchedFace =
      zio.aws.rekognition.model.SearchedFace(faceId.map(value => value))
    def faceId: Optional[FaceId]
    def getFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("faceId", faceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchedFace
  ) extends zio.aws.rekognition.model.SearchedFace.ReadOnly {
    override val faceId: Optional[FaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.faceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchedFace
  ): zio.aws.rekognition.model.SearchedFace.ReadOnly = new Wrapper(impl)
}
