package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchUsersResponse(
    userMatches: Optional[Iterable[zio.aws.rekognition.model.UserMatch]] =
      Optional.Absent,
    faceModelVersion: Optional[String] = Optional.Absent,
    searchedFace: Optional[zio.aws.rekognition.model.SearchedFace] =
      Optional.Absent,
    searchedUser: Optional[zio.aws.rekognition.model.SearchedUser] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchUsersResponse = {
    import SearchUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchUsersResponse
      .builder()
      .optionallyWith(
        userMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userMatches)
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .optionallyWith(searchedFace.map(value => value.buildAwsValue()))(
        _.searchedFace
      )
      .optionallyWith(searchedUser.map(value => value.buildAwsValue()))(
        _.searchedUser
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchUsersResponse.ReadOnly =
    zio.aws.rekognition.model.SearchUsersResponse.wrap(buildAwsValue())
}
object SearchUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchUsersResponse =
      zio.aws.rekognition.model.SearchUsersResponse(
        userMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        faceModelVersion.map(value => value),
        searchedFace.map(value => value.asEditable),
        searchedUser.map(value => value.asEditable)
      )
    def userMatches
        : Optional[List[zio.aws.rekognition.model.UserMatch.ReadOnly]]
    def faceModelVersion: Optional[String]
    def searchedFace: Optional[zio.aws.rekognition.model.SearchedFace.ReadOnly]
    def searchedUser: Optional[zio.aws.rekognition.model.SearchedUser.ReadOnly]
    def getUserMatches: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UserMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("userMatches", userMatches)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
    def getSearchedFace
        : ZIO[Any, AwsError, zio.aws.rekognition.model.SearchedFace.ReadOnly] =
      AwsError.unwrapOptionField("searchedFace", searchedFace)
    def getSearchedUser
        : ZIO[Any, AwsError, zio.aws.rekognition.model.SearchedUser.ReadOnly] =
      AwsError.unwrapOptionField("searchedUser", searchedUser)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchUsersResponse
  ) extends zio.aws.rekognition.model.SearchUsersResponse.ReadOnly {
    override val userMatches
        : Optional[List[zio.aws.rekognition.model.UserMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.UserMatch.wrap(item)
          }.toList
        )
    override val faceModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.faceModelVersion())
      .map(value => value: String)
    override val searchedFace
        : Optional[zio.aws.rekognition.model.SearchedFace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchedFace())
        .map(value => zio.aws.rekognition.model.SearchedFace.wrap(value))
    override val searchedUser
        : Optional[zio.aws.rekognition.model.SearchedUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchedUser())
        .map(value => zio.aws.rekognition.model.SearchedUser.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchUsersResponse
  ): zio.aws.rekognition.model.SearchUsersResponse.ReadOnly = new Wrapper(impl)
}
