package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  Percent,
  UserId,
  FaceId,
  CollectionId,
  MaxUserResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchUsersRequest(
    collectionId: CollectionId,
    userId: Optional[UserId] = Optional.Absent,
    faceId: Optional[FaceId] = Optional.Absent,
    userMatchThreshold: Optional[Percent] = Optional.Absent,
    maxUsers: Optional[MaxUserResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchUsersRequest = {
    import SearchUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchUsersRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        faceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.faceId)
      .optionallyWith(
        userMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.userMatchThreshold)
      .optionallyWith(
        maxUsers.map(value => MaxUserResults.unwrap(value): Integer)
      )(_.maxUsers)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchUsersRequest.ReadOnly =
    zio.aws.rekognition.model.SearchUsersRequest.wrap(buildAwsValue())
}
object SearchUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchUsersRequest =
      zio.aws.rekognition.model.SearchUsersRequest(
        collectionId,
        userId.map(value => value),
        faceId.map(value => value),
        userMatchThreshold.map(value => value),
        maxUsers.map(value => value)
      )
    def collectionId: CollectionId
    def userId: Optional[UserId]
    def faceId: Optional[FaceId]
    def userMatchThreshold: Optional[Percent]
    def maxUsers: Optional[MaxUserResults]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("faceId", faceId)
    def getUserMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("userMatchThreshold", userMatchThreshold)
    def getMaxUsers: ZIO[Any, AwsError, MaxUserResults] =
      AwsError.unwrapOptionField("maxUsers", maxUsers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchUsersRequest
  ) extends zio.aws.rekognition.model.SearchUsersRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.rekognition.model.primitives.UserId(value))
    override val faceId: Optional[FaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.faceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
    override val userMatchThreshold: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.userMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val maxUsers: Optional[MaxUserResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxUsers())
      .map(value => zio.aws.rekognition.model.primitives.MaxUserResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchUsersRequest
  ): zio.aws.rekognition.model.SearchUsersRequest.ReadOnly = new Wrapper(impl)
}
