package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchUsersByImageResponse(
    userMatches: Optional[Iterable[zio.aws.rekognition.model.UserMatch]] =
      Optional.Absent,
    faceModelVersion: Optional[String] = Optional.Absent,
    searchedFace: Optional[zio.aws.rekognition.model.SearchedFaceDetails] =
      Optional.Absent,
    unsearchedFaces: Optional[
      Iterable[zio.aws.rekognition.model.UnsearchedFace]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchUsersByImageResponse = {
    import SearchUsersByImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchUsersByImageResponse
      .builder()
      .optionallyWith(
        userMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userMatches)
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .optionallyWith(searchedFace.map(value => value.buildAwsValue()))(
        _.searchedFace
      )
      .optionallyWith(
        unsearchedFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsearchedFaces)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.SearchUsersByImageResponse.ReadOnly =
    zio.aws.rekognition.model.SearchUsersByImageResponse.wrap(buildAwsValue())
}
object SearchUsersByImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchUsersByImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchUsersByImageResponse =
      zio.aws.rekognition.model.SearchUsersByImageResponse(
        userMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        faceModelVersion.map(value => value),
        searchedFace.map(value => value.asEditable),
        unsearchedFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userMatches
        : Optional[List[zio.aws.rekognition.model.UserMatch.ReadOnly]]
    def faceModelVersion: Optional[String]
    def searchedFace
        : Optional[zio.aws.rekognition.model.SearchedFaceDetails.ReadOnly]
    def unsearchedFaces
        : Optional[List[zio.aws.rekognition.model.UnsearchedFace.ReadOnly]]
    def getUserMatches: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UserMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("userMatches", userMatches)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
    def getSearchedFace: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.SearchedFaceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("searchedFace", searchedFace)
    def getUnsearchedFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.UnsearchedFace.ReadOnly
    ]] = AwsError.unwrapOptionField("unsearchedFaces", unsearchedFaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchUsersByImageResponse
  ) extends zio.aws.rekognition.model.SearchUsersByImageResponse.ReadOnly {
    override val userMatches
        : Optional[List[zio.aws.rekognition.model.UserMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.UserMatch.wrap(item)
          }.toList
        )
    override val faceModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.faceModelVersion())
      .map(value => value: String)
    override val searchedFace
        : Optional[zio.aws.rekognition.model.SearchedFaceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchedFace())
        .map(value => zio.aws.rekognition.model.SearchedFaceDetails.wrap(value))
    override val unsearchedFaces
        : Optional[List[zio.aws.rekognition.model.UnsearchedFace.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unsearchedFaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.UnsearchedFace.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchUsersByImageResponse
  ): zio.aws.rekognition.model.SearchUsersByImageResponse.ReadOnly =
    new Wrapper(impl)
}
