package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  MaxUserResults,
  Percent,
  CollectionId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchUsersByImageRequest(
    collectionId: CollectionId,
    image: zio.aws.rekognition.model.Image,
    userMatchThreshold: Optional[Percent] = Optional.Absent,
    maxUsers: Optional[MaxUserResults] = Optional.Absent,
    qualityFilter: Optional[zio.aws.rekognition.model.QualityFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchUsersByImageRequest = {
    import SearchUsersByImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchUsersByImageRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .image(image.buildAwsValue())
      .optionallyWith(
        userMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.userMatchThreshold)
      .optionallyWith(
        maxUsers.map(value => MaxUserResults.unwrap(value): Integer)
      )(_.maxUsers)
      .optionallyWith(qualityFilter.map(value => value.unwrap))(_.qualityFilter)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchUsersByImageRequest.ReadOnly =
    zio.aws.rekognition.model.SearchUsersByImageRequest.wrap(buildAwsValue())
}
object SearchUsersByImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchUsersByImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchUsersByImageRequest =
      zio.aws.rekognition.model.SearchUsersByImageRequest(
        collectionId,
        image.asEditable,
        userMatchThreshold.map(value => value),
        maxUsers.map(value => value),
        qualityFilter.map(value => value)
      )
    def collectionId: CollectionId
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def userMatchThreshold: Optional[Percent]
    def maxUsers: Optional[MaxUserResults]
    def qualityFilter: Optional[zio.aws.rekognition.model.QualityFilter]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getUserMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("userMatchThreshold", userMatchThreshold)
    def getMaxUsers: ZIO[Any, AwsError, MaxUserResults] =
      AwsError.unwrapOptionField("maxUsers", maxUsers)
    def getQualityFilter
        : ZIO[Any, AwsError, zio.aws.rekognition.model.QualityFilter] =
      AwsError.unwrapOptionField("qualityFilter", qualityFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchUsersByImageRequest
  ) extends zio.aws.rekognition.model.SearchUsersByImageRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val userMatchThreshold: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.userMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val maxUsers: Optional[MaxUserResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxUsers())
      .map(value => zio.aws.rekognition.model.primitives.MaxUserResults(value))
    override val qualityFilter
        : Optional[zio.aws.rekognition.model.QualityFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualityFilter())
        .map(value => zio.aws.rekognition.model.QualityFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchUsersByImageRequest
  ): zio.aws.rekognition.model.SearchUsersByImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
