package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{S3KeyPrefix, S3Bucket}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Destination(
    bucket: Optional[S3Bucket] = Optional.Absent,
    keyPrefix: Optional[S3KeyPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.S3Destination = {
    import S3Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.S3Destination
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        keyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.keyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.S3Destination.ReadOnly =
    zio.aws.rekognition.model.S3Destination.wrap(buildAwsValue())
}
object S3Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.S3Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.S3Destination =
      zio.aws.rekognition.model.S3Destination(
        bucket.map(value => value),
        keyPrefix.map(value => value)
      )
    def bucket: Optional[S3Bucket]
    def keyPrefix: Optional[S3KeyPrefix]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.S3Destination
  ) extends zio.aws.rekognition.model.S3Destination.ReadOnly {
    override val bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.rekognition.model.primitives.S3Bucket(value))
    override val keyPrefix: Optional[S3KeyPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPrefix())
      .map(value => zio.aws.rekognition.model.primitives.S3KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.S3Destination
  ): zio.aws.rekognition.model.S3Destination.ReadOnly = new Wrapper(impl)
}
